/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment;

import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.api.deployment.archive.WritableArchiveEntry;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.ApplicationInfoProvider;
import org.glassfish.internal.deployment.DeploymentTracing;

public abstract class GenericHandler
implements ArchiveHandler {
    @Inject
    protected ServiceLocator habitat;

    public void expand(ReadableArchive source, WritableArchive target, DeploymentContext context) throws IOException {
        Enumeration e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            InputStream is = source.getEntry(entryName);
            try {
                if (is == null) continue;
                WritableArchiveEntry output = target.putNextEntry(entryName);
                try {
                    FileUtils.copy((InputStream)is, (OutputStream)output);
                }
                finally {
                    if (output == null) continue;
                    output.close();
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        Manifest manifest = source.getManifest();
        if (manifest != null) {
            try (WritableArchiveEntry output = target.putNextEntry("META-INF/MANIFEST.MF");){
                manifest.write((OutputStream)output);
            }
        }
    }

    public String getDefaultApplicationName(ReadableArchive archive, DeploymentContext context) {
        ApplicationInfoProvider nameProvider = (ApplicationInfoProvider)this.habitat.getService(ApplicationInfoProvider.class, new Annotation[0]);
        DeploymentTracing tracing = null;
        if (context != null) {
            tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class);
        }
        if (tracing != null) {
            tracing.addMark(DeploymentTracing.Mark.APPINFO_PROVIDED);
        }
        String appName = null;
        if (nameProvider != null && (appName = nameProvider.getNameFor(archive, context)) != null) {
            return appName;
        }
        return this.getDefaultApplicationNameFromArchiveName(archive);
    }

    public String getDefaultApplicationNameFromArchiveName(ReadableArchive archive) {
        String appName = archive.getName();
        int lastDot = appName.lastIndexOf(46);
        if (lastDot != -1 && appName.substring(lastDot).equalsIgnoreCase("." + this.getArchiveType())) {
            appName = appName.substring(0, lastDot);
        }
        return appName;
    }

    public String getDefaultApplicationName(ReadableArchive archive) {
        return this.getDefaultApplicationName(archive, null);
    }

    public String getVersionIdentifier(ReadableArchive archive) {
        return null;
    }

    public Manifest getManifest(ReadableArchive archive) throws IOException {
        return archive.getManifest();
    }

    public List<URI> getClassPathURIs(ReadableArchive archive) {
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(archive.getURI());
        return uris;
    }

    public boolean requiresAnnotationScanning(ReadableArchive archive) {
        return true;
    }
}

