/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.concurrent.ExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class Http2Configuration {
    public static final int DEFAULT_MAX_HEADER_LIST_SIZE = 4096;
    public static final float DEFAULT_STREAMS_HIGH_WATER_MARK = 0.5f;
    public static final float DEFAULT_STREAMS_CLEAN_PERCENTAGE = 0.5f;
    public static final int DEFAULT_CLEAN_FREQUENCY_CHECK = 50;
    private volatile int maxConcurrentStreams;
    private volatile int initialWindowSize;
    private volatile int maxFramePayloadSize;
    private volatile int maxHeaderListSize;
    private volatile float streamsHighWaterMark;
    private volatile float cleanPercentage;
    private volatile int cleanFrequencyCheck;
    private volatile boolean disableCipherCheck;
    private volatile boolean priorKnowledge;
    private volatile boolean pushEnabled;
    private final ExecutorService executorService;
    private final ThreadPoolConfig threadPoolConfig;

    private Http2Configuration(Http2ConfigurationBuilder builder) {
        this.maxConcurrentStreams = builder.maxConcurrentStreams;
        this.initialWindowSize = builder.initialWindowSize;
        this.maxFramePayloadSize = builder.maxFramePayloadSize;
        this.maxHeaderListSize = builder.maxHeaderListSize;
        this.disableCipherCheck = builder.disableCipherCheck;
        this.priorKnowledge = builder.priorKnowledge;
        this.threadPoolConfig = builder.threadPoolConfig;
        this.executorService = builder.executorService;
        this.pushEnabled = builder.pushEnabled;
        this.streamsHighWaterMark = builder.streamsHighWaterMark;
        this.cleanPercentage = builder.cleanPercentage;
        this.cleanFrequencyCheck = builder.cleanFrequencyCheck;
    }

    public static Http2ConfigurationBuilder builder() {
        return new Http2ConfigurationBuilder();
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public int getMaxFramePayloadSize() {
        return this.maxFramePayloadSize;
    }

    public void setMaxFramePayloadSize(int maxFramePayloadSize) {
        this.maxFramePayloadSize = maxFramePayloadSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public void setMaxHeaderListSize(int maxHeaderListSize) {
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public boolean isDisableCipherCheck() {
        return this.disableCipherCheck;
    }

    public void setDisableCipherCheck(boolean disableCipherCheck) {
        this.disableCipherCheck = disableCipherCheck;
    }

    public boolean isPriorKnowledge() {
        return this.priorKnowledge;
    }

    public void setPriorKnowledge(boolean priorKnowledge) {
        this.priorKnowledge = priorKnowledge;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public void setPushEnabled(boolean pushEnabled) {
        this.pushEnabled = pushEnabled;
    }

    public float getStreamsHighWaterMark() {
        return this.streamsHighWaterMark;
    }

    public void setStreamsHighWaterMark(float streamsHighWaterMark) {
        this.streamsHighWaterMark = streamsHighWaterMark;
    }

    public float getCleanPercentage() {
        return this.cleanPercentage;
    }

    public void setCleanPercentage(float cleanPercentage) {
        this.cleanPercentage = cleanPercentage;
    }

    public int getCleanFrequencyCheck() {
        return this.cleanFrequencyCheck;
    }

    public void setCleanFrequencyCheck(int cleanFrequencyCheck) {
        this.cleanFrequencyCheck = cleanFrequencyCheck;
    }

    public ThreadPoolConfig getThreadPoolConfig() {
        return this.threadPoolConfig;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public static final class Http2ConfigurationBuilder {
        private int maxConcurrentStreams = -1;
        private int initialWindowSize = -1;
        private int maxFramePayloadSize = -1;
        private int maxHeaderListSize = 4096;
        private boolean disableCipherCheck;
        private boolean priorKnowledge;
        private boolean pushEnabled = true;
        private float streamsHighWaterMark = 0.5f;
        private float cleanPercentage = 0.5f;
        private int cleanFrequencyCheck = 50;
        private ThreadPoolConfig threadPoolConfig;
        private ExecutorService executorService;

        private Http2ConfigurationBuilder() {
        }

        public Http2ConfigurationBuilder maxConcurrentStreams(int val) {
            this.maxConcurrentStreams = val;
            return this;
        }

        public Http2ConfigurationBuilder initialWindowSize(int val) {
            this.initialWindowSize = val;
            return this;
        }

        public Http2ConfigurationBuilder maxFramePayloadSize(int val) {
            this.maxFramePayloadSize = val;
            return this;
        }

        public Http2ConfigurationBuilder maxHeaderListSize(int val) {
            this.maxHeaderListSize = val;
            return this;
        }

        public Http2ConfigurationBuilder disableCipherCheck(boolean val) {
            this.disableCipherCheck = val;
            return this;
        }

        public Http2ConfigurationBuilder threadPoolConfig(ThreadPoolConfig val) {
            this.threadPoolConfig = val;
            return this;
        }

        public Http2ConfigurationBuilder executorService(ExecutorService val) {
            this.threadPoolConfig = null;
            this.executorService = val;
            return this;
        }

        public Http2ConfigurationBuilder priorKnowledge(boolean val) {
            this.priorKnowledge = val;
            return this;
        }

        public Http2ConfigurationBuilder enablePush(boolean val) {
            this.pushEnabled = val;
            return this;
        }

        public Http2ConfigurationBuilder streamsHighWaterMark(float val) {
            this.streamsHighWaterMark = val;
            return this;
        }

        public Http2ConfigurationBuilder cleanPercentage(float val) {
            this.cleanPercentage = val;
            return this;
        }

        public Http2ConfigurationBuilder cleanFrequencyCheck(int val) {
            this.cleanFrequencyCheck = val;
            return this;
        }

        public Http2Configuration build() {
            return new Http2Configuration(this);
        }
    }
}

