/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.persistence.core.sessions.CoreSession;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.IDResolver;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshallerHandler;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

public class XMLUnmarshaller
extends org.eclipse.persistence.internal.oxm.XMLUnmarshaller<AbstractSession, XMLContext, XMLDescriptor, IDResolver, MediaType, XMLRoot, XMLUnmarshallerHandler, XMLUnmarshalListener>
implements Cloneable {
    public static final int NONVALIDATING = 0;
    public static final int SCHEMA_VALIDATION = 3;
    public static final int DTD_VALIDATION = 2;

    protected XMLUnmarshaller(XMLContext xmlContext) {
        this(xmlContext, (Map<String, Boolean>)null);
        this.setMediaType(MediaType.APPLICATION_XML);
    }

    protected XMLUnmarshaller(XMLContext xmlContext, Map<String, Boolean> parserFeatures) {
        super(xmlContext, parserFeatures);
        this.setMediaType(MediaType.APPLICATION_XML);
    }

    protected XMLUnmarshaller(XMLUnmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
        this.setValidationMode(xmlUnmarshaller.getValidationMode());
    }

    @Override
    public XMLUnmarshaller clone() {
        return new XMLUnmarshaller(this);
    }

    @Override
    public XMLRoot createRoot() {
        return new XMLRoot();
    }

    @Override
    public org.eclipse.persistence.internal.oxm.record.UnmarshalRecord createUnmarshalRecord(XMLDescriptor xmlDescriptor, AbstractSession session) {
        UnmarshalRecord wrapper = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        return wrapper.getUnmarshalRecord();
    }

    @Override
    public MediaType getMediaType() {
        return (MediaType)super.getMediaType();
    }

    @Override
    public XMLUnmarshalListener getUnmarshalListener() {
        return (XMLUnmarshalListener)super.getUnmarshalListener();
    }

    @Override
    public void setUnmarshalListener(XMLUnmarshalListener listener) {
        super.setUnmarshalListener(listener);
    }

    @Override
    public XMLUnmarshallerHandler getUnmarshallerHandler() {
        if (null == this.xmlUnmarshallerHandler) {
            this.xmlUnmarshallerHandler = new XMLUnmarshallerHandler(this);
        }
        return (XMLUnmarshallerHandler)this.xmlUnmarshallerHandler;
    }

    @Override
    public XMLContext getXMLContext() {
        return (XMLContext)this.getContext();
    }

    @Override
    public void setMediaType(MediaType mediaType) {
        super.setMediaType(mediaType);
    }

    public void setValidationMode(int validationMode) {
        if (validationMode == 3) {
            this.initializeSchemas();
        }
        this.platformUnmarshaller.setValidationMode(validationMode);
    }

    @Override
    public void setXMLContext(XMLContext value) {
        this.context = value;
    }

    @Override
    public IDResolver getIDResolver() {
        return (IDResolver)super.getIDResolver();
    }

    @Override
    public void setIDResolver(IDResolver idResolver) {
        super.setIDResolver(idResolver);
    }

    @Override
    protected void initialize(Map<String, Boolean> parserFeatures) {
        super.initialize(parserFeatures);
        this.setValidationMode(0);
    }

    private void initializeSchemas() {
        if (!this.schemasAreInitialized) {
            HashSet<String> schemas = new HashSet<String>();
            int numberOfSessions = ((XMLContext)this.context).getSessions().size();
            for (int x = 0; x < numberOfSessions; ++x) {
                for (XMLDescriptor xmlDescriptor : ((CoreSession)((XMLContext)this.context).getSessions().get(x)).getDescriptors().values()) {
                    URL schemaURL;
                    XMLSchemaReference xmlSchemaReference = xmlDescriptor.getSchemaReference();
                    if (null == xmlSchemaReference || null == (schemaURL = xmlSchemaReference.getURL())) continue;
                    schemas.add(schemaURL.toString());
                }
            }
            schemas.remove(null);
            this.platformUnmarshaller.setSchemas(schemas.toArray());
            this.schemasAreInitialized = true;
        }
    }
}

