/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.OrderableList;
import com.sun.webui.jsf.renderkit.html.ListRendererBase;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.json.JsonObject;
import java.io.IOException;

public final class OrderableListRenderer
extends ListRendererBase {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component == null) {
            return;
        }
        if (!(component instanceof OrderableList)) {
            String message = "Component " + component.toString() + " has been associated with an OrderableListRenderer.  This renderer can only be used by components  that extend com.sun.webui.jsf.component.Selector.";
            throw new FacesException(message);
        }
        this.renderListComponent(context, (OrderableList)component, OrderableListRenderer.getStyles(component, context));
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        String id = component.getClientId(context).concat("_list_value");
        OrderableListRenderer.decode(context, component, id);
    }

    private void renderListComponent(FacesContext context, OrderableList component, String[] styles) throws IOException {
        if (component.isReadOnly()) {
            UIComponent label = component.getHeaderComponent();
            OrderableListRenderer.renderReadOnlyList(component, label, context, styles[15]);
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        OrderableListRenderer.renderOpenEncloser(component, context, "div", styles[15]);
        UIComponent headerComponent = component.getHeaderComponent();
        if (headerComponent != null) {
            if (!component.isLabelOnTop()) {
                writer.writeText((Object)"\n", null);
                writer.startElement("span", (UIComponent)component);
                writer.writeAttribute("class", (Object)styles[10], null);
                writer.writeText((Object)"\n", null);
                RenderingUtilities.renderComponent(headerComponent, context);
                writer.writeText((Object)"\n", null);
                writer.endElement("span");
                writer.writeText((Object)"\n", null);
            } else {
                RenderingUtilities.renderComponent(headerComponent, context);
                writer.startElement("br", (UIComponent)component);
                writer.endElement("br");
            }
        }
        this.renderColumnTop(component, writer, styles[10]);
        String id = component.getClientId(context).concat("_list");
        OrderableListRenderer.renderList(component, id, context, styles);
        this.renderColumnBottom(writer);
        this.renderColumnTop(component, writer, styles[10]);
        this.renderButtons(component, context, writer, styles);
        this.renderColumnBottom(writer);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[11], null);
        writer.endElement("div");
        UIComponent footerComponent = component.getFacet("footer");
        if (footerComponent != null) {
            writer.startElement("div", (UIComponent)component);
            writer.writeText((Object)"\n", null);
            RenderingUtilities.renderComponent(footerComponent, context);
            writer.writeText((Object)"\n", null);
            writer.endElement("div");
            writer.writeText((Object)"\n", null);
        }
        String jsID = component.getClientId(context);
        OrderableListRenderer.renderHiddenValue((UIComponent)component, context, writer, styles[15]);
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        this.renderJavaScript((UIComponent)component, context, writer, styles);
    }

    private void renderJavaScript(UIComponent component, FacesContext context, ResponseWriter writer, String[] styles) throws IOException {
        JsonObject initProps = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("id", component.getClientId(context)).add("moveMessage", styles[14]).build();
        JavaScriptUtilities.renderInitScriptTag(writer, "orderableList", initProps, JavaScriptUtilities.renderCall("update_buttons", "editableList", component.getClientId(context)));
    }

    private void renderColumnTop(OrderableList component, ResponseWriter writer, String style) throws IOException {
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)style, null);
        writer.writeText((Object)"\n", null);
    }

    private void renderColumnBottom(ResponseWriter writer) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    private void renderButtons(OrderableList component, FacesContext context, ResponseWriter writer, String[] styles) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        String style = "padding-left:10;padding-right:10";
        writer.writeAttribute("style", (Object)style, null);
        writer.writeText((Object)"\n", null);
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("class", (Object)styles[12], null);
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("align", (Object)"center", null);
        writer.writeAttribute("width", (Object)"125", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(component.getMoveUpButtonComponent(context), context);
        writer.writeText((Object)"\n", null);
        this.renderButton(component, component.getMoveDownButtonComponent(context), styles[9], writer, context);
        if (component.isMoveTopBottom()) {
            this.renderButton(component, component.getMoveTopButtonComponent(context), styles[8], writer, context);
            this.renderButton(component, component.getMoveBottomButtonComponent(context), styles[9], writer, context);
        }
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    private void renderButton(OrderableList list, UIComponent comp, String style, ResponseWriter writer, FacesContext context) throws IOException {
        if (comp == null) {
            return;
        }
        writer.startElement("div", (UIComponent)list);
        writer.writeAttribute("class", (Object)style, null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(comp, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    private void addComponentSingleRow(OrderableList list, UIComponent component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", (UIComponent)list);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)list);
        RenderingUtilities.renderComponent(component, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private static String[] getStyles(UIComponent component, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[]{JavaScriptUtilities.getDomNode(context, component) + ".onChange(); " + "return false;", theme.getStyleClass("LIST"), theme.getStyleClass("LIST_DISABLED"), theme.getStyleClass("LIST_OPTION"), theme.getStyleClass("LIST_OPTION_DISABLED"), theme.getStyleClass("LIST_OPTION_SELECTED"), theme.getStyleClass("LIST_OPTION_GROUP"), theme.getStyleClass("LIST_OPTION_SEPARATOR"), theme.getStyleClass("ADDREMOVE_HORIZONTAL_BETWEEN"), theme.getStyleClass("ADDREMOVE_HORIZONTAL_WITHIN"), theme.getStyleClass("ADDREMOVE_HORIZONTAL_ALIGN"), theme.getStyleClass("ADDREMOVE_HORIZONTAL_LAST"), theme.getStyleClass("ADDREMOVE_BUTTON_TABLE"), null, theme.getMessage("OrderableList.moveMessage"), theme.getStyleClass("HIDDEN")};
        return styles;
    }

    private static void log(String msg) {
        LogUtil.finest(OrderableListRenderer.class.getName() + "::" + msg);
    }
}

