/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.resizer;

import com.sun.enterprise.resource.AssocWithThreadResourceHandle;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.pool.PoolProperties;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.enterprise.resource.pool.resizer.Resizer;
import jakarta.resource.spi.ManagedConnection;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class AssocWithThreadPoolResizer
extends Resizer {
    private static final System.Logger LOG = System.getLogger(AssocWithThreadPoolResizer.class.getName());

    public AssocWithThreadPoolResizer(PoolInfo poolInfo, DataStructure ds, PoolProperties pp, ResourceHandler handler, boolean preferValidateOverRecreate) {
        super(poolInfo, ds, pp, handler, preferValidateOverRecreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scaleDownPool(int scaleDownQuantity, boolean forced) {
        if (this.pool.getResizeQuantity() <= 0 || !forced) {
            return;
        }
        if (scaleDownQuantity > this.dataStructure.getResourcesSize() - this.pool.getSteadyPoolSize()) {
            scaleDownQuantity = 0;
        }
        LOG.log(System.Logger.Level.DEBUG, "Scaling down pool by quantity: {0}", scaleDownQuantity);
        HashSet<ResourceHandle> resourcesToRemove = new HashSet<ResourceHandle>();
        try {
            for (ResourceHandle handle : this.dataStructure.getAllResources()) {
                if (scaleDownQuantity <= 0) continue;
                handle.lock();
                try {
                    if (handle.getResourceState().isBusy()) continue;
                    resourcesToRemove.add(handle);
                    ((AssocWithThreadResourceHandle)handle).setUnusable();
                    --scaleDownQuantity;
                }
                finally {
                    handle.unlock();
                }
            }
        }
        catch (Throwable throwable) {
            for (ResourceHandle resourceToRemove : resourcesToRemove) {
                if (!this.dataStructure.getAllResources().contains(resourceToRemove)) continue;
                this.dataStructure.removeResource(resourceToRemove);
            }
            throw throwable;
        }
        for (ResourceHandle resourceToRemove : resourcesToRemove) {
            if (!this.dataStructure.getAllResources().contains(resourceToRemove)) continue;
            this.dataStructure.removeResource(resourceToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int removeIdleAndInvalidResources() {
        int poolSizeBeforeRemoval = this.dataStructure.getResourcesSize();
        long currentTime = System.currentTimeMillis();
        int validConnectionsCounter = 0;
        int idleConnKeptInSteadyCounter = 0;
        HashSet<ResourceHandle> resourcesToValidate = new HashSet<ResourceHandle>();
        HashSet<ResourceHandle> resourcesToRemove = new HashSet<ResourceHandle>();
        try {
            for (ResourceHandle handle : this.dataStructure.getAllResources()) {
                handle.lock();
                try {
                    ResourceState state = handle.getResourceState();
                    if (state.isBusy()) continue;
                    AssocWithThreadResourceHandle asociatedHandle = (AssocWithThreadResourceHandle)handle;
                    if (currentTime - state.getLastUsage() < this.pool.getIdleTimeout()) {
                        if (state.isEnlisted() || state.isBusy() || !asociatedHandle.isAssociated()) continue;
                        asociatedHandle.setAssociated(false);
                        ++validConnectionsCounter;
                        resourcesToValidate.add(handle);
                        continue;
                    }
                    boolean isResourceEligibleForRemoval = this.isResourceEligibleForRemoval(handle, validConnectionsCounter);
                    if (isResourceEligibleForRemoval) {
                        resourcesToRemove.add(handle);
                        asociatedHandle.setUnusable();
                        continue;
                    }
                    ++idleConnKeptInSteadyCounter;
                    LOG.log(System.Logger.Level.DEBUG, "PreferValidateOverRecreate: Keeping idle resource {0} in the steady part of the free pool as the RA reports it to be valid ({1} <= {2})", handle, ++validConnectionsCounter, this.pool.getSteadyPoolSize());
                }
                finally {
                    handle.unlock();
                }
            }
        }
        catch (Throwable throwable) {
            for (ResourceHandle resourceToRemove : resourcesToRemove) {
                if (!this.dataStructure.getAllResources().contains(resourceToRemove)) continue;
                this.dataStructure.removeResource(resourceToRemove);
            }
            throw throwable;
        }
        for (ResourceHandle resourceToRemove : resourcesToRemove) {
            if (!this.dataStructure.getAllResources().contains(resourceToRemove)) continue;
            this.dataStructure.removeResource(resourceToRemove);
        }
        int noOfInvalidResources = this.removeInvalidResources(resourcesToValidate);
        if (this.preferValidateOverRecreate) {
            LOG.log(System.Logger.Level.DEBUG, "Idle resources validated and kept in the steady pool {0}: {1}", this.poolInfo, idleConnKeptInSteadyCounter);
            LOG.log(System.Logger.Level.DEBUG, "Number of Idle resources freed from pool {0}: {1}", this.poolInfo, resourcesToRemove.size());
            LOG.log(System.Logger.Level.DEBUG, "Number of Invalid resources removed from pool {0}: {1}", this.poolInfo, noOfInvalidResources);
        } else {
            LOG.log(System.Logger.Level.DEBUG, "Number of Idle resources freed from pool {0}: {1}", this.poolInfo, resourcesToRemove.size());
            LOG.log(System.Logger.Level.DEBUG, "Number of Invalid resources removed from pool {0}: {1}", this.poolInfo, noOfInvalidResources);
        }
        return poolSizeBeforeRemoval - this.dataStructure.getResourcesSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeInvalidResources(Set<ResourceHandle> freeConnectionsToValidate) {
        int invalidConnectionsCount = 0;
        try {
            LOG.log(System.Logger.Level.DEBUG, "Sending a set of free connections to RA, of size:  {0}", freeConnectionsToValidate.size());
            try {
                for (ResourceHandle handle : freeConnectionsToValidate) {
                    if (handle == null) continue;
                    HashSet<ManagedConnection> connectionsToTest = new HashSet<ManagedConnection>();
                    connectionsToTest.add(handle.getResource());
                    Set<ManagedConnection> invalidConnections = this.handler.getInvalidConnections(connectionsToTest);
                    if (invalidConnections == null || invalidConnections.isEmpty()) continue;
                    invalidConnectionsCount = this.validateAndRemoveResource(handle, invalidConnections);
                }
            }
            catch (Throwable throwable) {
                LOG.log(System.Logger.Level.DEBUG, "No. of invalid resources received from RA: {0}", invalidConnectionsCount);
                throw throwable;
            }
            LOG.log(System.Logger.Level.DEBUG, "No. of invalid resources received from RA: {0}", invalidConnectionsCount);
        }
        catch (Exception re) {
            LOG.log(System.Logger.Level.WARNING, "Removing invalid resources from the pool " + String.valueOf(this.poolInfo) + " failed!", (Throwable)re);
        }
        return invalidConnectionsCount;
    }
}

