/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ParenJExpr;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class UnaryJExpr
extends AbstractJExpr {
    private final Tokens$.PUNCT.UNOP op;
    private final AbstractJExpr expr;
    private final boolean postfix;

    UnaryJExpr(Tokens$.PUNCT.UNOP op, AbstractJExpr expr) {
        this(op, expr, 2, false);
    }

    UnaryJExpr(Tokens$.PUNCT.UNOP op, AbstractJExpr expr, int prec) {
        this(op, expr, prec, false);
    }

    UnaryJExpr(Tokens$.PUNCT.UNOP op, AbstractJExpr expr, int prec, boolean postfix) {
        super(prec);
        this.op = op;
        this.expr = expr.prec() > prec ? new ParenJExpr(expr) : expr;
        this.postfix = postfix;
    }

    AbstractJExpr getExpression() {
        return this.expr;
    }

    boolean isPostfix() {
        return this.postfix;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        if (this.isPostfix()) {
            writer.write(this.expr);
            writer.write(FormatPreferences.Space.AT_UNARY);
            writer.write(this.op);
        } else {
            writer.write(this.op);
            writer.write(FormatPreferences.Space.AT_UNARY);
            writer.write(this.expr);
        }
    }
}

