/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt.report;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.annotations.BaseUrl;
import org.jboss.logging.annotations.ResolutionDoc;
import org.jboss.logging.processor.apt.report.AsciidocReportWriter;
import org.jboss.logging.processor.apt.report.ReportType;
import org.jboss.logging.processor.apt.report.XmlReportWriter;
import org.jboss.logging.processor.model.LoggerMessageMethod;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.util.Expressions;

public abstract class ReportWriter
implements Closeable {
    static final String DEFAULT_ID = "--";
    private final String baseUrl;
    final MessageInterface messageInterface;
    final String messageIdFormat;

    ReportWriter(MessageInterface messageInterface) {
        this.messageInterface = messageInterface;
        int idLen = messageInterface.getIdLength();
        this.messageIdFormat = idLen > 0 ? messageInterface.projectCode() + "%0" + messageInterface.getIdLength() + "d" : messageInterface.projectCode() + "%d";
        this.baseUrl = messageInterface.isAnnotatedWith(BaseUrl.class) ? messageInterface.getAnnotation(BaseUrl.class).value() : null;
    }

    public static ReportWriter of(ReportType reportType, MessageInterface messageInterface, BufferedWriter writer) {
        if (reportType == ReportType.ASCIIDOC) {
            return new AsciidocReportWriter(messageInterface, writer);
        }
        if (reportType == ReportType.XML) {
            try {
                return new XmlReportWriter(messageInterface, writer);
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException("Failed to create XML report writer.", e);
            }
        }
        throw new IllegalArgumentException("Type " + String.valueOf((Object)reportType) + " is not a known report type.");
    }

    public abstract void writeHeader(String var1) throws IOException;

    public abstract void writeDetail(MessageMethod var1) throws IOException;

    public abstract void writeFooter() throws IOException;

    abstract ReportType getReportType();

    String getLogLevel(LoggerMessageMethod method) {
        String logLevel = method.logLevel();
        int index = logLevel.lastIndexOf(46);
        if (index > 0) {
            return logLevel.substring(index + 1);
        }
        return logLevel;
    }

    String getUrl(MessageMethod messageMethod, String id) {
        ResolutionDoc resolutionDoc = this.getResolutionDoc(messageMethod);
        if (resolutionDoc == null || resolutionDoc.skip() || DEFAULT_ID.equals(id)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String base = this.baseUrl == null ? "" : this.baseUrl;
        String path = resolutionDoc.path();
        String suffix = resolutionDoc.suffix();
        String url = resolutionDoc.url();
        if (!url.isEmpty()) {
            base = url;
        }
        if (!base.isEmpty()) {
            result.append(base);
            if (!base.endsWith("/") && !base.endsWith("#")) {
                result.append('/');
            }
        }
        if (path.isEmpty()) {
            result.append(id);
        } else {
            result.append(path);
        }
        if (suffix.isEmpty()) {
            result.append(this.getReportType().getExtension());
        } else {
            result.append(suffix);
        }
        return Expressions.resolve(this.messageInterface.expressionProperties(), result.toString());
    }

    private ResolutionDoc getResolutionDoc(MessageMethod messageMethod) {
        if (messageMethod.isAnnotatedWith(ResolutionDoc.class)) {
            return messageMethod.getAnnotation(ResolutionDoc.class);
        }
        return this.messageInterface.getAnnotation(ResolutionDoc.class);
    }
}

