/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.InformixPlatform;

public class Informix11Platform
extends InformixPlatform {
    private static final long serialVersionUID = 1L;

    public Informix11Platform() {
        this.setShouldBindLiterals(false);
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.currentDateOperator());
        this.addOperator(this.currentTimeOperator());
        this.addOperator(this.distinctOperator());
    }

    protected ExpressionOperator currentDateOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "CURRENT YEAR TO DAY");
    }

    protected ExpressionOperator currentTimeOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "CURRENT YEAR TO FRACTION(3)");
    }

    protected ExpressionOperator distinctOperator() {
        ExpressionOperator operator = ExpressionOperator.distinct();
        operator.printsAs("DISTINCT ");
        return operator;
    }

    @Override
    public boolean isInformixOuterJoin() {
        return false;
    }

    @Override
    protected void appendBoolean(Boolean booleanValue, Writer writer) throws IOException {
        if (booleanValue == null) {
            throw new IllegalArgumentException("booleanValue", new NullPointerException("booleanValue"));
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer", new NullPointerException("writer"));
        }
        if (Boolean.TRUE.equals(booleanValue)) {
            writer.write("'t'");
        } else {
            writer.write("'f'");
        }
    }

    @Override
    public boolean dontBindUpdateAllQueryUsingTempTables() {
        return true;
    }

    @Override
    public boolean shouldAlwaysUseTempStorageForModifyAll() {
        return true;
    }

    @Override
    public boolean supportsLocalTempTables() {
        return true;
    }

    @Override
    protected String getCreateTempTableSqlPrefix() {
        return "CREATE TEMP TABLE ";
    }

    @Override
    public DatabaseTable getTempTableForTable(DatabaseTable table) {
        if (table == null) {
            throw new IllegalArgumentException("table", new NullPointerException("table"));
        }
        return new DatabaseTable("TL_" + table.getName(), "", table.shouldUseDelimiters(), this.getStartDelimiter(), this.getEndDelimiter());
    }

    @Override
    protected String getCreateTempTableSqlSuffix() {
        return " WITH NO LOG";
    }

    @Override
    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable table, Collection<DatabaseField> pkFields, Collection<DatabaseField> assignedFields) throws IOException {
        writer.write("UPDATE ");
        String tableName = table.getQualifiedNameDelimited(this);
        writer.write(tableName);
        writer.write(" SET ");
        int size = assignedFields.size();
        if (size > 1) {
            writer.write("(");
        }
        Informix11Platform.writeFieldsList(writer, assignedFields, this);
        if (size > 1) {
            writer.write(")");
        }
        writer.write(" = (SELECT ");
        Informix11Platform.writeFieldsList(writer, assignedFields, this);
        writer.write(" FROM ");
        String tempTableName = this.getTempTableForTable(table).getQualifiedNameDelimited(this);
        writer.write(tempTableName);
        Informix11Platform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
        writer.write(") WHERE EXISTS(SELECT ");
        writer.write(pkFields.iterator().next().getNameDelimited(this));
        writer.write(" FROM ");
        writer.write(tempTableName);
        Informix11Platform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
        writer.write(")");
    }

    @Override
    public Object getObjectFromResultSet(ResultSet resultSet, int columnNumber, int jdbcType, AbstractSession session) throws SQLException {
        Object returnValue = null;
        switch (jdbcType) {
            case -1: {
                if (resultSet == null) break;
                returnValue = resultSet.getString(columnNumber);
                break;
            }
            default: {
                returnValue = super.getObjectFromResultSet(resultSet, columnNumber, jdbcType, session);
            }
        }
        return returnValue;
    }
}

