/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.SelectItemsIterator;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.MenuRenderer;
import com.sun.faces.util.RequestStateManager;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.io.IOException;

public class SelectManyCheckboxListRenderer
extends MenuRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.SELECTMANYCHECKBOX);

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Object borderObj;
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        Boolean newTableRow = false;
        int border = 0;
        String alignStr = (String)component.getAttributes().get("layout");
        if (null != alignStr) {
            newTableRow = alignStr.equalsIgnoreCase("list") ? null : Boolean.valueOf(alignStr.equalsIgnoreCase("pageDirection"));
        }
        if (null != (borderObj = component.getAttributes().get("border"))) {
            border = (Integer)borderObj;
        }
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)((Object)component)).getConverter();
        }
        this.renderBeginText(component, border, newTableRow, context, true);
        SelectItemsIterator<SelectItem> items = RenderKitUtils.getSelectItems(context, component);
        Object currentSelections = this.getCurrentSelectedValues(component);
        Object[] submittedValues = this.getSubmittedSelectedValues(component);
        HtmlBasicRenderer.OptionComponentInfo optionInfo = new HtmlBasicRenderer.OptionComponentInfo(component);
        int idx = -1;
        while (items.hasNext()) {
            SelectItem curItem = (SelectItem)items.next();
            ++idx;
            if (curItem instanceof SelectItemGroup) {
                SelectItem[] itemsArray;
                if (curItem.getLabel() != null) {
                    if (newTableRow == Boolean.TRUE) {
                        writer.startElement("tr", component);
                    }
                    writer.startElement(newTableRow != null ? "td" : "li", component);
                    writer.writeText(curItem.getLabel(), component, "label");
                    if (newTableRow != null) {
                        writer.endElement("td");
                        if (newTableRow.booleanValue()) {
                            writer.endElement("tr");
                        }
                    }
                }
                if (newTableRow != null) {
                    if (newTableRow.booleanValue()) {
                        writer.startElement("tr", component);
                    }
                    writer.startElement("td", component);
                }
                writer.writeText("\n", component, null);
                this.renderBeginText(component, 0, newTableRow, context, false);
                for (SelectItem element : itemsArray = ((SelectItemGroup)curItem).getSelectItems()) {
                    this.renderOption(context, component, converter, element, currentSelections, submittedValues, newTableRow, idx++, optionInfo);
                }
                this.renderEndText(component, newTableRow, context);
                writer.endElement(newTableRow != null ? "td" : "li");
                if (newTableRow != Boolean.TRUE) continue;
                writer.endElement("tr");
                writer.writeText("\n", component, null);
                continue;
            }
            this.renderOption(context, component, converter, curItem, currentSelections, submittedValues, newTableRow, idx, optionInfo);
        }
        this.renderEndText(component, newTableRow, context);
    }

    @Override
    protected boolean isBehaviorSource(FacesContext ctx, String behaviorSourceId, String componentClientId) {
        if (behaviorSourceId == null) {
            return false;
        }
        char sepChar = UINamingContainer.getSeparatorChar(ctx);
        String actualBehaviorId = behaviorSourceId.lastIndexOf(sepChar) != -1 ? behaviorSourceId.substring(0, behaviorSourceId.lastIndexOf(sepChar)) : behaviorSourceId;
        return actualBehaviorId.equals(componentClientId);
    }

    protected void renderBeginText(UIComponent component, int border, Boolean newTableRow, FacesContext context, boolean outerElement) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement(newTableRow != null ? "table" : "ul", component);
        if (newTableRow != null && border != Integer.MIN_VALUE) {
            writer.writeAttribute("border", border, "border");
        }
        if (outerElement) {
            if (this.shouldWriteIdAttribute(component)) {
                this.writeIdAttributeIfNecessary(context, writer, component);
            }
            String styleClass = (String)component.getAttributes().get("styleClass");
            String style = (String)component.getAttributes().get("style");
            if (styleClass != null) {
                writer.writeAttribute("class", styleClass, "class");
            }
            if (style != null) {
                writer.writeAttribute("style", style, "style");
            }
        }
        writer.writeText("\n", component, null);
        if (newTableRow == Boolean.FALSE) {
            writer.writeText("\t", component, null);
            writer.startElement("tr", component);
            writer.writeText("\n", component, null);
        }
    }

    protected void renderEndText(UIComponent component, Boolean newTableRow, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (newTableRow == Boolean.FALSE) {
            writer.writeText("\t", component, null);
            writer.endElement("tr");
            writer.writeText("\n", component, null);
        }
        writer.endElement(newTableRow != null ? "table" : "ul");
    }

    protected void renderOption(FacesContext context, UIComponent component, Converter converter, SelectItem curItem, Object currentSelections, Object[] submittedValues, Boolean newTableRow, int itemNumber, HtmlBasicRenderer.OptionComponentInfo optionInfo) throws IOException {
        Object itemValue;
        Object valuesArray;
        String valueString = this.getFormattedValue(context, component, curItem.getValue(), converter);
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = valueString;
        } else {
            valuesArray = currentSelections;
            itemValue = curItem.getValue();
        }
        RequestStateManager.set(context, "com.sun.faces.ComponentForValue", component);
        boolean isSelected = this.isSelected(context, component, itemValue, valuesArray, converter);
        if (optionInfo.isHideNoSelection() && curItem.isNoSelectionOption() && currentSelections != null && !isSelected) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (newTableRow == Boolean.TRUE) {
            writer.writeText("\t", component, null);
            writer.startElement("tr", component);
            writer.writeText("\n", component, null);
        }
        writer.startElement(newTableRow != null ? "td" : "li", component);
        writer.writeText("\n", component, null);
        writer.startElement("input", component);
        writer.writeAttribute("name", component.getClientId(context), "clientId");
        String idString = component.getClientId(context) + UINamingContainer.getSeparatorChar(context) + Integer.toString(itemNumber);
        writer.writeAttribute("id", idString, "id");
        writer.writeAttribute("value", valueString, "value");
        writer.writeAttribute("type", "checkbox", null);
        if (isSelected) {
            writer.writeAttribute(this.getSelectedTextString(), Boolean.TRUE, null);
        }
        if (!optionInfo.isDisabled() && curItem.isDisabled()) {
            writer.writeAttribute("disabled", true, "disabled");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES, SelectManyCheckboxListRenderer.getNonOnClickSelectBehaviors(component));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        RenderKitUtils.renderSelectOnclick(context, component, false);
        writer.endElement("input");
        writer.startElement("label", component);
        writer.writeAttribute("for", idString, "for");
        StringBuilder labelClass = new StringBuilder();
        String style = optionInfo.isDisabled() || curItem.isDisabled() ? optionInfo.getDisabledClass() : optionInfo.getEnabledClass();
        if (style != null) {
            labelClass.append(style);
        }
        if ((style = this.isSelected(context, component, itemValue, valuesArray, converter) ? optionInfo.getSelectedClass() : optionInfo.getUnselectedClass()) != null) {
            if (labelClass.length() > 0) {
                labelClass.append(' ');
            }
            labelClass.append(style);
        }
        writer.writeAttribute("class", labelClass.toString(), "labelClass");
        String itemLabel = curItem.getLabel();
        if (itemLabel == null) {
            itemLabel = valueString;
        }
        writer.writeText(" ", component, null);
        if (!curItem.isEscape()) {
            writer.write(itemLabel);
        } else {
            writer.writeText(itemLabel, component, "label");
        }
        writer.endElement("label");
        writer.endElement(newTableRow != null ? "td" : "li");
        writer.writeText("\n", component, null);
        if (newTableRow == Boolean.TRUE) {
            writer.writeText("\t", component, null);
            writer.endElement("tr");
            writer.writeText("\n", component, null);
        }
    }

    String getSelectedTextString() {
        return "checked";
    }
}

