/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ConsoleHelp;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public abstract class AdminDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4390215343313774916L;
    public static final int OK = 1;
    public static final int APPLY = 2;
    public static final int CLEAR = 4;
    public static final int RESET = 8;
    public static final int CANCEL = 16;
    public static final int CLOSE = 32;
    public static final int HELP = 64;
    private EventListenerList aListeners = new EventListenerList();
    private int whichButtons = 0;
    protected JPanel buttonPanel = null;
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JButton closeButton = null;
    protected JButton clearButton = null;
    protected JButton resetButton = null;
    protected JButton applyButton = null;
    protected JButton helpButton = null;
    private static boolean helpDisplayed = false;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public AdminDialog(Frame parent, String title) {
        this(parent, title, 81);
    }

    public AdminDialog(Frame parent, String title, int whichButtons) {
        super(parent, title, true);
        this.whichButtons = whichButtons;
        this.initContentPane(true);
        this.pack();
    }

    public AdminDialog(Frame parent, String title, int whichButtons, boolean border) {
        super(parent, title, true);
        this.whichButtons = whichButtons;
        this.initContentPane(border);
        this.pack();
    }

    public void addAdminEventListener(AdminEventListener l) {
        this.aListeners.add(AdminEventListener.class, l);
    }

    public void removeAdminEventListener(AdminEventListener l) {
        this.aListeners.remove(AdminEventListener.class, l);
    }

    public void fireAdminEventDispatched(AdminEvent ae) {
        Object[] l = this.aListeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != AdminEventListener.class) continue;
            ((AdminEventListener)l[i + 1]).adminEventDispatched(ae);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.doOK();
        } else if (source == this.applyButton) {
            this.doApply();
        } else if (source == this.cancelButton) {
            this.doCancel();
        } else if (source == this.closeButton) {
            this.doClose();
        } else if (source == this.clearButton) {
            this.doClear();
        } else if (source == this.resetButton) {
            this.doReset();
        } else if (source == this.helpButton) {
            this.doHelp();
        }
    }

    private void initContentPane(boolean border) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        if (border) {
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        JPanel workPanel = this.createWorkPanel();
        this.buttonPanel = this.createButtonPanel();
        panel.add((Component)workPanel, "Center");
        panel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add(panel);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        if (this.useButton(1)) {
            this.okButton = new JButton(acr.getString("A1076"));
            this.okButton.addActionListener(this);
            buttonPanel.add(this.okButton);
        }
        if (this.useButton(2)) {
            this.applyButton = new JButton(acr.getString("A1077"));
            this.applyButton.addActionListener(this);
            buttonPanel.add(this.applyButton);
        }
        if (this.useButton(4)) {
            this.clearButton = new JButton(acr.getString("A1078"));
            this.clearButton.addActionListener(this);
            buttonPanel.add(this.clearButton);
        }
        if (this.useButton(8)) {
            this.resetButton = new JButton(acr.getString("A1079"));
            this.resetButton.addActionListener(this);
            buttonPanel.add(this.resetButton);
        }
        if (this.useButton(16)) {
            this.cancelButton = new JButton(acr.getString("A1080"));
            this.cancelButton.addActionListener(this);
            buttonPanel.add(this.cancelButton);
        }
        if (this.useButton(32)) {
            this.closeButton = new JButton(acr.getString("A1081"));
            this.closeButton.addActionListener(this);
            buttonPanel.add(this.closeButton);
        }
        if (this.useButton(64)) {
            this.helpButton = new JButton(acr.getString("A1082"));
            this.helpButton.setEnabled(false);
            this.helpButton.addActionListener(this);
            buttonPanel.add(this.helpButton);
        }
        return buttonPanel;
    }

    public void setHelpId(String helpId) {
        if (this.helpButton == null) {
            return;
        }
        if (ConsoleHelp.helpLoaded()) {
            HelpBroker hb = ConsoleHelp.hb[0];
            HelpSet hs = ConsoleHelp.hs[0];
            this.helpButton.addActionListener(ConsoleHelp.hl[0]);
            hb.enableHelp(this.helpButton, helpId, hs);
            this.helpButton.setEnabled(true);
        }
    }

    public void setDefaultButton(int whichButton) {
        JButton button = null;
        if (this.useButton(1)) {
            button = this.okButton;
        } else if (this.useButton(2)) {
            button = this.applyButton;
        } else if (this.useButton(4)) {
            button = this.clearButton;
        } else if (this.useButton(8)) {
            button = this.resetButton;
        } else if (this.useButton(16)) {
            button = this.cancelButton;
        } else if (this.useButton(32)) {
            button = this.closeButton;
        } else if (this.useButton(64)) {
            button = this.helpButton;
        }
        if (button != null) {
            this.getRootPane().setDefaultButton(button);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && helpDisplayed) {
            HelpBroker hb = ConsoleHelp.hb[0];
            ((DefaultHelpBroker)hb).setActivationWindow(null);
            hb.setDisplayed(false);
        }
        super.setVisible(visible);
    }

    private boolean useButton(int buttonFlag) {
        return (this.whichButtons & buttonFlag) == buttonFlag;
    }

    public abstract JPanel createWorkPanel();

    public abstract void doOK();

    public abstract void doApply();

    public abstract void doCancel();

    public abstract void doClose();

    public abstract void doClear();

    public abstract void doReset();

    public void doHelp() {
        HelpBroker hb = ConsoleHelp.hb[0];
        ((DefaultHelpBroker)hb).setActivationWindow(this);
        hb.setDisplayed(true);
        helpDisplayed = true;
    }
}

