/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.core.helper.CoreField;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ChoiceUnmarshalContext;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeObjectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLDirectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLObjectReferenceMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeObjectMapping;
import org.eclipse.persistence.internal.oxm.mappings.DirectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.xml.sax.Attributes;

public class XMLChoiceObjectMappingNodeValue
extends MappingNodeValue {
    private NodeValue choiceElementNodeValue;
    private Map<Class, NodeValue> choiceElementNodeValues;
    private ChoiceObjectMapping xmlChoiceMapping;
    private XMLChoiceObjectMappingNodeValue nullCapableNodeValue;
    private Field xmlField;

    public XMLChoiceObjectMappingNodeValue(ChoiceObjectMapping mapping, Field xmlField) {
        this.xmlChoiceMapping = mapping;
        this.xmlField = xmlField;
        this.initializeNodeValue();
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return this.choiceElementNodeValue.isOwningNode(xPathFragment);
    }

    public void initializeNodeValue() {
        Mapping xmlMapping = (Mapping)this.xmlChoiceMapping.getChoiceElementMappings().get(this.xmlField);
        this.choiceElementNodeValue = this.getNodeValueForMapping(xmlMapping);
        for (Map.Entry entry : this.xmlChoiceMapping.getChoiceElementMappingsByClass().entrySet()) {
            Mapping mappingForClass;
            Field field = (Field)this.xmlChoiceMapping.getClassToFieldMappings().get(entry.getKey());
            if (field == null || !field.equals(this.xmlField) || (mappingForClass = (Mapping)entry.getValue()) == xmlMapping) continue;
            if (this.choiceElementNodeValues == null) {
                this.choiceElementNodeValues = new HashMap<Class, NodeValue>();
            }
            this.choiceElementNodeValues.put(entry.getKey(), this.getNodeValueForMapping(mappingForClass));
        }
    }

    private NodeValue getNodeValueForMapping(Mapping xmlMapping) {
        if (xmlMapping instanceof BinaryDataMapping) {
            return new XMLBinaryDataMappingNodeValue((BinaryDataMapping)xmlMapping);
        }
        if (xmlMapping instanceof DirectMapping) {
            return new XMLDirectMappingNodeValue((DirectMapping)xmlMapping);
        }
        if (xmlMapping instanceof ObjectReferenceMapping) {
            return new XMLObjectReferenceMappingNodeValue((ObjectReferenceMapping)xmlMapping, this.xmlField);
        }
        return new XMLCompositeObjectMappingNodeValue((CompositeObjectMapping)xmlMapping);
    }

    public void setNullCapableNodeValue(XMLChoiceObjectMappingNodeValue nodeValue) {
        this.nullCapableNodeValue = nodeValue;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlChoiceMapping.isReadOnly()) {
            return false;
        }
        Object value = this.xmlChoiceMapping.getFieldValue(object, session, marshalRecord);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Class<?> valueClass = null;
        if (value instanceof Root) {
            Root root = (Root)value;
            for (CoreField next : this.xmlChoiceMapping.getFields()) {
                for (XPathFragment fragment = ((Field)next).getXPathFragment(); fragment != null && !fragment.nameIsText; fragment = fragment.getNextFragment()) {
                    if (fragment.getNextFragment() != null && !fragment.getHasText() || !fragment.getLocalName().equals(root.getLocalName())) continue;
                    String fragUri = fragment.getNamespaceURI();
                    String namespaceUri = root.getNamespaceURI();
                    if ((namespaceUri != null || fragUri != null) && (namespaceUri == null || fragUri == null || !namespaceUri.equals(fragUri))) continue;
                    if (next == this.xmlField) {
                        return this.choiceElementNodeValue.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
                    }
                    return false;
                }
            }
            valueClass = root.getObject().getClass();
        }
        if (value != null) {
            Class<?> theClass;
            if (valueClass == null) {
                valueClass = value.getClass();
            }
            Object fieldForClass = null;
            for (theClass = valueClass; theClass != null && (fieldForClass = (Field)this.xmlChoiceMapping.getClassToFieldMappings().get(valueClass)) == null; theClass = theClass.getSuperclass()) {
            }
            if (fieldForClass != null && fieldForClass.equals(this.xmlField)) {
                NodeValue nodeValue;
                if (this.choiceElementNodeValues != null && (nodeValue = this.choiceElementNodeValues.get(theClass)) != null) {
                    return nodeValue.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
                }
                return this.choiceElementNodeValue.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
            }
            List sourceFields = null;
            for (theClass = valueClass; theClass != null && (sourceFields = this.xmlChoiceMapping.getClassToSourceFieldsMappings().get(theClass)) == null; theClass = theClass.getSuperclass()) {
            }
            if (sourceFields != null && sourceFields.contains(this.xmlField)) {
                return this.choiceElementNodeValue.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
            }
        }
        return false;
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        if (null != this.xmlChoiceMapping.getConverter()) {
            UnmarshalContext unmarshalContext = unmarshalRecord.getUnmarshalContext();
            unmarshalRecord.setUnmarshalContext(new ChoiceUnmarshalContext(unmarshalContext, this.xmlChoiceMapping));
            this.choiceElementNodeValue.endElement(xPathFragment, unmarshalRecord);
            unmarshalRecord.setUnmarshalContext(unmarshalContext);
        } else {
            this.choiceElementNodeValue.endElement(xPathFragment, unmarshalRecord);
        }
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        return this.choiceElementNodeValue.startElement(xPathFragment, unmarshalRecord, atts);
    }

    @Override
    public void setXPathNode(XPathNode xPathNode) {
        super.setXPathNode(xPathNode);
        this.choiceElementNodeValue.setXPathNode(xPathNode);
        if (this.choiceElementNodeValues != null) {
            for (NodeValue next : this.choiceElementNodeValues.values()) {
                next.setXPathNode(xPathNode);
            }
        }
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String URI2, String localName, String value) {
        this.choiceElementNodeValue.attribute(unmarshalRecord, URI2, localName, value);
    }

    @Override
    public Mapping getMapping() {
        return this.xmlChoiceMapping;
    }

    @Override
    public boolean isWhitespaceAware() {
        return this.choiceElementNodeValue.isWhitespaceAware();
    }
}

