/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ConnectorNamingEvent;
import com.sun.appserv.connectors.internal.spi.ConnectorNamingEventListener;
import com.sun.appserv.jdbc.DataSource;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ApplicationLifeCycleEventListener;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.TransactionHelperImpl;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import org.glassfish.internal.api.Globals;
import org.glassfish.persistence.common.I18NHelper;

public class SunTransactionHelper
extends TransactionHelperImpl
implements ConnectorNamingEventListener {
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", SunTransactionHelper.class.getClassLoader());
    private static List<PersistenceManagerFactory> pmf_list;
    private static EjbContainerUtil ejbContainerUtil;
    private static final Object pmf_listSyncObject;
    private final List<ApplicationLifeCycleEventListener> applicationLifeCycleEventListeners = new ArrayList<ApplicationLifeCycleEventListener>();

    SunTransactionHelper() {
    }

    @Override
    public Transaction getTransaction() {
        try {
            return TransactionManagerFinder.appserverTM.getTransaction();
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(e.getMessage());
        }
        catch (ExceptionInInitializerError err) {
            throw new JDOFatalInternalException(err.getMessage());
        }
    }

    @Override
    public UserTransaction getUserTransaction() {
        try {
            InitialContext ctx = (InitialContext)Class.forName("javax.naming.InitialContext").newInstance();
            return (UserTransaction)ctx.lookup("java:comp/UserTransaction");
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(e.getMessage());
        }
    }

    @Override
    public void registerSynchronization(Transaction jta, Synchronization sync) throws RollbackException, SystemException {
        ejbContainerUtil.registerPMSync(jta, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceManagerFactory replaceInternalPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        Object object = pmf_listSyncObject;
        synchronized (object) {
            int i = pmf_list.indexOf(pmf);
            if (i == -1) {
                pmf_list.add(pmf);
                return pmf;
            }
            return pmf_list.get(i);
        }
    }

    @Override
    public String getDDLNamePrefix(Object info) {
        return DeploymentHelper.getDDLNamePrefix(info);
    }

    @Override
    public Connection getNonTransactionalConnection(Object resource, String username, char[] password) throws SQLException {
        Connection rc = null;
        if (resource instanceof DataSource) {
            DataSource ds = (DataSource)resource;
            rc = username == null ? ds.getNonTxConnection() : ds.getNonTxConnection(username, new String(password));
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "ejb.SunTransactionHelper.wrongdatasourcetype", resource.getClass().getName()));
        }
        return rc;
    }

    @Override
    public TransactionManager getLocalTransactionManager() {
        try {
            return TransactionManagerFinder.appserverTM;
        }
        catch (ExceptionInInitializerError err) {
            throw new JDOFatalInternalException(err.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerApplicationLifeCycleEventListener(ApplicationLifeCycleEventListener listener) {
        List<ApplicationLifeCycleEventListener> list = this.applicationLifeCycleEventListeners;
        synchronized (list) {
            this.applicationLifeCycleEventListeners.add(listener);
        }
    }

    @Override
    public void notifyApplicationUnloaded(ClassLoader classLoader) {
        for (ApplicationLifeCycleEventListener applicationLifeCycleEventListener : this.applicationLifeCycleEventListeners) {
            applicationLifeCycleEventListener.notifyApplicationUnloaded(classLoader);
        }
    }

    public void connectorNamingEventPerformed(ConnectorNamingEvent event) {
        if (event.getEventType() == 0) {
            String dsName = ConnectorsUtil.getPMJndiName((String)event.getJndiName());
            this.cleanUpResources(dsName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpResources(String name) {
        Object object = pmf_listSyncObject;
        synchronized (object) {
            Iterator<PersistenceManagerFactory> it = pmf_list.iterator();
            while (it.hasNext()) {
                PersistenceManagerFactory pmf = it.next();
                if (!pmf.getConnectionFactoryName().equals(name)) continue;
                it.remove();
            }
        }
    }

    static {
        pmf_listSyncObject = new Object();
        SunTransactionHelper helper = new SunTransactionHelper();
        EJBHelper.registerTransactionHelper(helper);
        ConnectorRuntime connectorRuntime = (ConnectorRuntime)Globals.getDefaultHabitat().getService(ConnectorRuntime.class, new Annotation[0]);
        connectorRuntime.registerConnectorNamingEventListener((ConnectorNamingEventListener)helper);
        pmf_list = new ArrayList<PersistenceManagerFactory>();
        ejbContainerUtil = (EjbContainerUtil)Globals.getDefaultHabitat().getService(EjbContainerUtil.class, new Annotation[0]);
    }

    private static class TransactionManagerFinder {
        private static final String AS_TM_NAME = "java:appserver/TransactionManager";
        static TransactionManager appserverTM = null;

        private TransactionManagerFinder() {
        }

        static {
            try {
                appserverTM = (TransactionManager)new InitialContext().lookup(AS_TM_NAME);
            }
            catch (Exception e) {
                throw new JDOFatalInternalException(e.getMessage());
            }
        }
    }
}

