/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.appclient;

import com.sun.enterprise.iiop.security.AlternateSecurityInterceptorFactory;
import com.sun.enterprise.iiop.security.SecClientRequestInterceptor;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.jvnet.hk2.annotations.Service;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@Service(name="ClientSecurityInterceptorFactory")
@Singleton
public class AppclientIIOPInterceptorFactory
implements IIOPInterceptorFactory {
    private static Logger _logger = null;
    final String interceptorFactory = System.getProperty("com.sun.enterprise.iiop.security.interceptorFactory");
    private ClientRequestInterceptor creq;
    @Inject
    private ProcessEnvironment penv;
    private AlternateSecurityInterceptorFactory altSecFactory;

    public ClientRequestInterceptor createClientRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (this.penv.getProcessType().isServer()) {
            return null;
        }
        if (this.altSecFactory != null || this.interceptorFactory != null && this.createAlternateSecurityInterceptorFactory()) {
            return this.altSecFactory.getClientRequestInterceptor(codec);
        }
        ClientRequestInterceptor ret = this.getClientInterceptorInstance(codec);
        return ret;
    }

    public ServerRequestInterceptor createServerRequestInterceptor(ORBInitInfo info, Codec codec) {
        return null;
    }

    private synchronized boolean createAlternateSecurityInterceptorFactory() {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.interceptorFactory);
            if (AlternateSecurityInterceptorFactory.class.isAssignableFrom(clazz) && !clazz.isInterface()) {
                this.altSecFactory = (AlternateSecurityInterceptorFactory)clazz.newInstance();
                return true;
            }
            _logger.log(Level.INFO, "Not a valid factory class: " + this.interceptorFactory + ". Must implement " + AlternateSecurityInterceptorFactory.class.getName());
        }
        catch (ClassNotFoundException ex) {
            _logger.log(Level.INFO, "Interceptor Factory class " + this.interceptorFactory + " not loaded: ", ex);
        }
        catch (InstantiationException ex) {
            _logger.log(Level.INFO, "Interceptor Factory class " + this.interceptorFactory + " not loaded: ", ex);
        }
        catch (IllegalAccessException ex) {
            _logger.log(Level.INFO, "Interceptor Factory class " + this.interceptorFactory + " not loaded: ", ex);
        }
        return false;
    }

    private synchronized ClientRequestInterceptor getClientInterceptorInstance(Codec codec) {
        if (this.creq == null) {
            this.creq = new SecClientRequestInterceptor("SecClientRequestInterceptor", codec);
        }
        return this.creq;
    }

    static {
        _logger = LogDomains.getLogger(AppclientIIOPInterceptorFactory.class, (String)"javax.enterprise.system.core.security");
    }
}

