/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public abstract class ServiceFactory
implements ConfigListener {
    public static final String SERVICE_PREFIX = "imq.";
    public static final String SERVICE_PROTOCOLTYPE_SUFFIX = ".protocoltype";
    public static final String SERVICE_HANDLER_SUFFIX = ".handler_name";
    public static final String SERVICE_THREADPOOL_MODEL_SUFFIX = ".threadpool_model";
    public static final String WEBSOCKET_HANDLER_NAME = "websocket";
    protected static boolean DEBUG = false;
    protected final Logger logger = Globals.getLogger();
    protected final BrokerResources br = Globals.getBrokerResources();
    private String factoryHandlerName = null;
    ConnectionManager conmgr = null;

    public static void enforceServiceHandler(String service, BrokerConfig config, ServiceManager sm) throws BrokerException {
        String prototype;
        if (sm == null) {
            return;
        }
        if ((service.equals("wsjms") || service.equals("wssjms")) && (prototype = config.getProperty(SERVICE_PREFIX + service + SERVICE_PROTOCOLTYPE_SUFFIX)) != null && !prototype.equalsIgnoreCase("ws") && !prototype.equalsIgnoreCase("wss")) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4450", prototype, service));
        }
        ServiceFactory sf = null;
        try {
            sf = sm.createServiceFactory(WEBSOCKET_HANDLER_NAME, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            throw new BrokerException(e.getMessage(), e);
        }
        if (sf != null) {
            sf.enforceServiceHandler(service, config);
        }
    }

    public void enforceServiceHandler(String service, BrokerConfig config) throws BrokerException {
    }

    public static boolean isDefaultStandardServiceName(String name) {
        return name.equals("jms") || name.equals("ssljms") || name.equals("admin") || name.equals("ssladmin") || name.equals("httpjms") || name.equals("httpsjms");
    }

    protected final void setFactoryHandlerName(String handlerName) {
        this.factoryHandlerName = handlerName;
    }

    public final String getFactoryHandlerName() {
        return this.factoryHandlerName;
    }

    protected abstract void checkFactoryHandlerName(String var1) throws IllegalAccessException;

    public void setConnectionManager(ConnectionManager conmgr) {
        this.conmgr = conmgr;
    }

    public abstract Service createService(String var1, int var2) throws BrokerException;

    public abstract void updateService(Service var1) throws BrokerException;

    public abstract void startMonitoringService(Service var1) throws BrokerException;

    public abstract void stopMonitoringService(Service var1) throws BrokerException;

    @Override
    public abstract void validate(String var1, String var2) throws PropertyUpdateException;

    @Override
    public abstract boolean update(String var1, String var2);

    public ConnectionManager getConnectionManager() {
        return this.conmgr;
    }
}

