/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.disk.PHashMap;
import com.sun.messaging.jmq.io.disk.PHashMapLoadException;
import com.sun.messaging.jmq.io.disk.PHashMapMMF;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class TxnAckList {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    BrokerConfig config = Globals.getConfig();
    static final String BASENAME = "txnack";
    private PHashMap tidMap = null;
    private boolean useMemoryMappedFile = true;
    private HashMap emptyHashMap = new HashMap();
    private TransactionAcknowledgement[] emptyAckArray = new TransactionAcknowledgement[0];
    private File backingFile = null;
    private LoadException loadException = null;

    TxnAckList(FileStore p, File topDir, boolean clear) throws BrokerException {
        SizeString filesize = this.config.getSizeProperty("imq.persist.file.transaction.file.size", 1024L);
        this.backingFile = new File(topDir, BASENAME);
        try {
            this.useMemoryMappedFile = this.config.getBooleanProperty("imq.persist.file.transaction.memorymappedfile.enabled", true);
            this.tidMap = this.useMemoryMappedFile ? new PHashMapMMF(this.backingFile, filesize.getBytes(), 1024, false, clear, Globals.isMinimumWritesFileStore(), Broker.isInProcess()) : new PHashMap(this.backingFile, filesize.getBytes(), 1024, false, clear, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4054", e);
            throw new BrokerException(this.br.getString("B4054"), e);
        }
        try {
            this.tidMap.load(p);
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(32, "B4054", e);
            throw new BrokerException(this.br.getString("B4054"), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4198", le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = this.tidMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of transaction data", w);
        }
        if (clear && Store.getDEBUG()) {
            this.logger.log(1, "TxnAckList initialized with clear option");
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "TxnAckList: loaded acks for " + this.tidMap.size() + " transactions");
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    TxnAckList(FileStore p, File topDir, File oldTop, boolean deleteold) throws BrokerException {
        File oldFile = new File(oldTop, BASENAME);
        PHashMap olddata = null;
        this.backingFile = new File(topDir, BASENAME);
        try {
            olddata = new PHashMap(oldFile, false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4156", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4156", oldFile, this.backingFile), e);
        }
        try {
            olddata.load(p);
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(32, "B4156", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4156", oldFile, this.backingFile), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4203", le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = olddata.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of transaction data in old store", w);
        }
        try {
            this.tidMap = this.config.getBooleanProperty("imq.persist.file.transaction.memorymappedfile.enabled", true) ? new PHashMapMMF(this.backingFile, oldFile.length(), 1024, false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess()) : new PHashMap(this.backingFile, oldFile.length(), 1024, false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4156", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4156", oldFile, this.backingFile), e);
        }
        try {
            this.tidMap.load(p);
        }
        catch (PHashMapLoadException | IOException | ClassNotFoundException e) {
            this.logger.log(32, "B4156", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4156", oldFile, this.backingFile), e);
        }
        w = this.tidMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of transaction data", w);
        }
        for (Map.Entry entry : olddata.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.tidMap.put(key, value);
        }
        olddata.close();
        if (Store.getDEBUG()) {
            this.logger.log(4, "TxnAckList: upgraded acks for " + this.tidMap.size() + " txns");
        }
        if (deleteold && !oldFile.delete()) {
            this.logger.log(32, "B1044", oldFile);
        }
    }

    void storeAck(TransactionUID tid, TransactionAcknowledgement ack, boolean sync) throws BrokerException {
        try {
            boolean putIfAbsent = false;
            HashSet acks = (HashSet)this.tidMap.get(tid);
            if (acks == null) {
                putIfAbsent = true;
                acks = new HashSet();
            } else if (acks.contains(ack)) {
                this.logger.log(32, "B3062", (Object)ack, tid);
                throw new BrokerException(this.br.getString("B3062", ack, tid));
            }
            acks.add(ack);
            Object oldValue = this.tidMap.put(tid, acks, putIfAbsent);
            if (putIfAbsent && oldValue != null) {
                acks = (HashSet)this.tidMap.get(tid);
                acks.add(ack);
                this.tidMap.put(tid, acks);
            }
            if (sync) {
                this.sync(tid);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4056", (Object)ack.toString(), tid.toString());
            throw new BrokerException(this.br.getString("B4056", ack.toString(), tid.toString()), e);
        }
    }

    void storeAcks(TransactionUID tid, TransactionAcknowledgement[] txnAcks, boolean sync) throws BrokerException {
        List<TransactionAcknowledgement> ackList = Arrays.asList(txnAcks);
        try {
            boolean putIfAbsent = false;
            HashSet acks = (HashSet)this.tidMap.get(tid);
            if (acks == null) {
                putIfAbsent = true;
                acks = new HashSet(ackList.size());
            }
            acks.addAll(ackList);
            Object oldValue = this.tidMap.put(tid, acks, putIfAbsent);
            if (putIfAbsent && oldValue != null) {
                acks = (HashSet)this.tidMap.get(tid);
                acks.addAll(ackList);
                this.tidMap.put(tid, acks);
            }
            if (sync) {
                this.sync(tid);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4056", (Object)ackList.toString(), tid.toString());
            throw new BrokerException(this.br.getString("B4056", ackList.toString(), tid.toString()), e);
        }
    }

    HashMap getAllAcks() {
        if (this.tidMap.size() == 0) {
            return this.emptyHashMap;
        }
        HashMap allacks = new HashMap(this.tidMap.size());
        Set entries = this.tidMap.entrySet();
        for (Map.Entry entry : entries) {
            HashSet set = (HashSet)entry.getValue();
            TransactionAcknowledgement[] acks = set.toArray(this.emptyAckArray);
            allacks.put(entry.getKey(), acks);
        }
        return allacks;
    }

    public TransactionUID[] getAllTids() {
        TransactionUID[] tids = null;
        ConcurrentHashMap.KeySetView s = this.tidMap.keySet();
        tids = new TransactionUID[s.size()];
        int i = 0;
        Iterator itr = s.iterator();
        while (itr.hasNext()) {
            tids[i] = (TransactionUID)itr.next();
        }
        return tids;
    }

    TransactionAcknowledgement[] getAcks(TransactionUID tid) throws BrokerException {
        HashSet acks = (HashSet)this.tidMap.get(tid);
        if (acks != null) {
            return acks.toArray(this.emptyAckArray);
        }
        return this.emptyAckArray;
    }

    void removeAcks(TransactionUID tid, boolean sync) throws BrokerException {
        try {
            HashSet acks = (HashSet)this.tidMap.remove(tid);
            if (sync) {
                this.sync(tid);
            }
            if (acks != null) {
                acks.clear();
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4060", tid.toString());
            throw new BrokerException(this.br.getString("B4060", tid.toString()), e);
        }
    }

    void clearAll(boolean sync) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnAckList.clearAll() called");
        }
        try {
            this.tidMap.clear();
            if (sync) {
                this.sync(null);
            }
        }
        catch (Exception e) {
            this.logger.log(32, this.br.getString("B4055", this.backingFile), e);
        }
    }

    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "TxnAckList: closing, " + this.tidMap.size() + " transactions has acks");
        }
        this.tidMap.close();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Txn acks", String.valueOf(this.tidMap.size()));
        return t;
    }

    void printInfo(PrintStream out) {
        out.println("\nTransaction acknowledgements");
        out.println("----------------------------");
        out.println("backing file: " + this.backingFile);
        out.println("Number of transactions containing acknowledgements: " + this.tidMap.size());
    }

    public int getNumberOfTxnAcks() {
        int size = 0;
        for (Map.Entry entry : this.tidMap.entrySet()) {
            HashSet acks = (HashSet)entry.getValue();
            size += acks.size();
        }
        return size;
    }

    void sync(TransactionUID tid) throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String msg = "TxnAckList sync() " + tid;
                this.logger.log(4, msg);
            }
            this.tidMap.force(tid);
        }
        catch (IOException e) {
            throw new BrokerException("Failed to synchronize data to disk for file: " + this.backingFile, e);
        }
    }

    public static void deleteAllFiles(File rootDir) throws BrokerException {
        boolean deleted;
        File file = new File(rootDir, BASENAME);
        if (file.exists() && !(deleted = file.delete())) {
            Object[] args = new String[]{BASENAME, rootDir.getPath(), "txnack.deleted"};
            Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2248", args));
            File nf = new File(rootDir, "txnack.deleted");
            if (!file.renameTo(nf)) {
                Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2249", file.getPath(), nf.getPath()));
                throw new BrokerException(Globals.getBrokerResources().getKString("B4362", file));
            }
        }
    }

    public void deleteAndBackupAllFiles(File rootDir) throws IOException {
        FileUtil.copyFile(this.backingFile, new File(rootDir, BASENAME + ".backup"));
        boolean deleted = this.backingFile.delete();
        if (!deleted) {
            this.logger.log(32, "Could not delete " + this.backingFile + " . Will delete on exit");
            this.backingFile.deleteOnExit();
        }
    }
}

