/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.AutoClusterBrokerMap;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.cluster.manager.BasicAutoClusterManagerImpl")
@Singleton
public class BasicAutoClusterManagerImpl
extends ClusterManagerImpl {
    @Override
    public String initialize(MQAddress address) throws BrokerException {
        if (Globals.getClusterID() == null) {
            throw new BrokerException("imq.cluster.clusterid must set");
        }
        String r = super.initialize(address);
        if (!(this.allBrokers instanceof AutoClusterBrokerMap)) {
            throw new BrokerException("Cluster configuration inconsistent: unexpected class " + this.allBrokers.getClass());
        }
        return r;
    }

    @Override
    protected void setupListeners() {
        this.config.addListener("imq.cluster.transport", this);
        this.config.addListener("imq.cluster.hostname", this);
        this.config.addListener("imq.cluster.port", this);
    }

    @Override
    public ClusteredBroker newClusteredBroker(MQAddress url, boolean isLocal, UID sid) throws BrokerException {
        ClusteredBroker cb = super.newClusteredBroker(url, isLocal, sid);
        ((ClusteredBrokerImpl)cb).setConfigBroker(true);
        return cb;
    }

    @Override
    public void reloadConfig() throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String[] props = new String[]{"imq.cluster.url"};
        this.config.reloadProps(Globals.getConfigName(), props, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String addBroker(MQAddress url, boolean isLocal, boolean isConfig, UID uid) throws NoSuchElementException, BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String name = null;
        ClusteredBroker cb = null;
        if (isLocal) {
            Map map = this.allBrokers;
            synchronized (map) {
                name = this.lookupBrokerID(url);
                if (name == null) {
                    cb = this.newClusteredBroker(url, isLocal, uid);
                    name = cb.getBrokerName();
                } else {
                    cb = this.getBroker(name);
                }
                Map map2 = this.allBrokers;
                synchronized (map2) {
                    this.allBrokers.put(name, cb);
                }
            }
        }
        name = this.lookupBrokerID(url);
        if (name != null) {
            cb = this.getBroker(name);
        }
        if (name == null || cb == null) {
            throw new NoSuchElementException("Unknown broker " + url);
        }
        if (uid != null) {
            cb.setBrokerSessionUID(uid);
        }
        if (isLocal) {
            cb.setStatus(257, null);
        }
        this.brokerChanged(ClusterReason.ADDED, cb.getBrokerName(), null, cb, uid, null);
        return name;
    }

    @Override
    protected Map initAllBrokers(MQAddress myaddr) throws BrokerException {
        String cstr = Globals.getConfig().getProperty("imq.cluster.autocluster.brokermapclass");
        if (cstr == null) {
            return super.initAllBrokers(myaddr);
        }
        try {
            if (Globals.isNucleusManagedBroker()) {
                AutoClusterBrokerMap map = (AutoClusterBrokerMap)Globals.getHabitat().getService(AutoClusterBrokerMap.class, cstr, new Annotation[0]);
                if (map == null) {
                    throw new BrokerException("Class " + cstr + " not found");
                }
                map.init(this, myaddr);
                return (Map)((Object)map);
            }
            Class<?> c = Class.forName(cstr);
            Class[] paramTypes = new Class[]{ClusterManagerImpl.class, MQAddress.class};
            Constructor<?> cons = c.getConstructor(paramTypes);
            Object[] paramArgs = new Object[]{this, myaddr};
            return (Map)cons.newInstance(paramArgs);
        }
        catch (Exception e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LinkedHashSet parseBrokerList() throws MalformedURLException {
        String val = this.config.getProperty("imq.cluster.brokerlist");
        if (val != null) {
            this.logger.log(8, "B2219", "imq.cluster.brokerlist=" + val);
        }
        if ((val = this.config.getProperty("imq.cluster.brokerlist.manual")) != null) {
            this.logger.log(8, "B2219", "imq.cluster.brokerlist.manual=" + val);
        }
        LinkedHashSet<MQAddress> brokers = new LinkedHashSet<MQAddress>();
        Map map = this.allBrokers;
        synchronized (map) {
            for (Object o : this.allBrokers.values()) {
                ClusteredBroker b = (ClusteredBroker)o;
                if (b.isLocalBroker()) continue;
                brokers.add(b.getBrokerURL());
            }
        }
        return brokers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupBrokerID(MQAddress address) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster manager is not initialized");
        }
        try {
            Map map = this.allBrokers;
            synchronized (map) {
                ((AutoClusterBrokerMap)((Object)this.allBrokers)).updateMap();
            }
        }
        catch (BrokerException e) {
            this.logger.logStack(16, e.getMessage(), e);
        }
        return super.lookupBrokerID(address);
    }

    @Override
    public Iterator getConfigBrokers() {
        return this.getKnownBrokers(true);
    }

    @Override
    public int getConfigBrokerCount() {
        return super.getKnownBrokerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getKnownBrokers(boolean refresh) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster manager is not initialized");
        }
        if (refresh) {
            try {
                Map map = this.allBrokers;
                synchronized (map) {
                    ((AutoClusterBrokerMap)((Object)this.allBrokers)).updateMap(true);
                }
            }
            catch (BrokerException e) {
                this.logger.logStack(16, e.getMessage(), e);
            }
        }
        return super.getKnownBrokers(refresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusteredBroker getBroker(String brokerid) {
        ClusteredBroker cb = super.getBroker(brokerid);
        if (cb != null) {
            return cb;
        }
        try {
            Map map = this.allBrokers;
            synchronized (map) {
                ((AutoClusterBrokerMap)((Object)this.allBrokers)).updateMap(true);
            }
        }
        catch (BrokerException e) {
            this.logger.logStack(16, e.getMessage(), e);
        }
        return super.getBroker(brokerid);
    }
}

