/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.grizzly;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.extras.grizzly.GrizzlyApp;
import org.glassfish.extras.grizzly.GrizzlyContainer;
import org.glassfish.extras.grizzly.GrizzlyModuleDescriptor;
import org.glassfish.extras.grizzly.IntrospectionUtils;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.jvnet.hk2.annotations.Service;

@Service(name="grizzly")
public class GrizzlyDeployer
implements Deployer<GrizzlyContainer, GrizzlyApp> {
    @Inject
    RequestDispatcher dispatcher;

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{GrizzlyModuleDescriptor.class}, null);
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return type.cast(new GrizzlyModuleDescriptor(context.getSource(), context.getLogger()));
    }

    public boolean prepare(DeploymentContext context) {
        return true;
    }

    public GrizzlyApp load(GrizzlyContainer container, DeploymentContext context) {
        GrizzlyModuleDescriptor configs = (GrizzlyModuleDescriptor)context.getModuleMetaData(GrizzlyModuleDescriptor.class);
        LinkedList<GrizzlyApp.Adapter> modules = new LinkedList<GrizzlyApp.Adapter>();
        Map<String, ArrayList<GrizzlyModuleDescriptor.GrizzlyProperty>> properties = configs.getProperties();
        for (Map.Entry<String, String> config : configs.getAdapters().entrySet()) {
            HttpHandler httpHandler;
            try {
                Class<?> adapterClass = context.getClassLoader().loadClass(config.getValue());
                httpHandler = (HttpHandler)HttpHandler.class.cast(adapterClass.newInstance());
                ArrayList<GrizzlyModuleDescriptor.GrizzlyProperty> list = properties.get(config.getValue());
                for (GrizzlyModuleDescriptor.GrizzlyProperty p : list) {
                    IntrospectionUtils.setProperty(httpHandler, p.name, p.value);
                }
                httpHandler.start();
            }
            catch (Exception e) {
                context.getLogger().log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
            modules.add(new GrizzlyApp.Adapter(config.getKey(), httpHandler));
        }
        return new GrizzlyApp(modules, this.dispatcher, context.getClassLoader());
    }

    public void unload(GrizzlyApp appContainer, DeploymentContext context) {
    }

    public void clean(DeploymentContext context) {
    }
}

