/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonFilter {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JsonFilter.class);
    private boolean defaultInclude;
    private List<Filter> filters = new ArrayList<Filter>();

    public JsonFilter() {
        this.defaultInclude = true;
    }

    public JsonFilter(Locale locale, String include, String exclude) throws Exception {
        this(locale, include, exclude, "name");
    }

    public JsonFilter(Locale locale, String include, String exclude, String identityAttr) throws Exception {
        if (include != null) {
            if (exclude != null) {
                String msg = localStrings.getLocalString("filter.includeAndExcludeFieldsSpecified", "__excludeFields cannot be specified when __includeFields is specified.");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build());
            }
            this.addFilter(new IdentityFilter(identityAttr)).addFilter(new IncludeFilter(locale, include));
            this.defaultInclude = false;
        } else if (exclude != null) {
            this.addFilter(new IdentityFilter(identityAttr)).addFilter(new ExcludeFilter(locale, exclude));
            this.defaultInclude = true;
        } else {
            this.defaultInclude = true;
        }
    }

    public JsonFilter addFilter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public JSONObject trim(JSONObject j) {
        this.newScope().trimJsonObject(j);
        return j;
    }

    public Scope newScope() {
        return new Scope();
    }

    public class Scope {
        private Stack<String> scopeStack = null;

        private Scope() {
            if (JsonFilter.this.filters.size() > 0) {
                this.scopeStack = new Stack();
            }
        }

        public JSONObject trim(JSONObject j) {
            new Scope().trimJsonObject(j);
            return j;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trimJsonObject(JSONObject j) {
            for (String property : this.getPropertyNames(j)) {
                if (!this.include(property)) {
                    j.remove(property);
                    continue;
                }
                try {
                    Object o = j.get(property);
                    if (o instanceof JSONObject) {
                        JSONObject next = (JSONObject)o;
                        this.beginObjectAttr(property);
                        try {
                            this.trimJsonObject(next);
                            continue;
                        }
                        finally {
                            this.endObjectAttr();
                            continue;
                        }
                    }
                    if (!(o instanceof JSONArray)) continue;
                    JSONArray ar = (JSONArray)o;
                    this.beginArrayAttr(property);
                    try {
                        this.trimJsonArray(ar);
                    }
                    finally {
                        this.endArrayAttr();
                    }
                }
                catch (JSONException jSONException) {}
            }
        }

        private List<String> getPropertyNames(JSONObject j) {
            ArrayList<String> rtn = new ArrayList<String>();
            Iterator it = j.keys();
            while (it.hasNext()) {
                String property = (String)it.next();
                rtn.add(property);
            }
            return rtn;
        }

        private void trimJsonArray(JSONArray ar) {
            for (int i = 0; i < ar.length(); ++i) {
                try {
                    Object o = ar.get(i);
                    if (o instanceof JSONObject) {
                        this.trimJsonObject((JSONObject)o);
                        continue;
                    }
                    if (!(o instanceof JSONArray)) continue;
                    this.trimJsonArray((JSONArray)o);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }

        public boolean includeAny(String[] properties) {
            for (String property : properties) {
                if (!this.include(property)) continue;
                return true;
            }
            return false;
        }

        public boolean include(String property) {
            if (this.scopeStack != null) {
                String attr = this.scopeStack.isEmpty() ? property : this.scopeStack.peek() + "." + property;
                for (Filter filter : JsonFilter.this.filters) {
                    Result r = filter.filter(attr);
                    if (r == Result.Include) {
                        return true;
                    }
                    if (r != Result.Exclude) continue;
                    return false;
                }
            }
            return JsonFilter.this.defaultInclude;
        }

        public void beginObjectAttr(String name) {
            this.beginAttr(name);
        }

        public void endObjectAttr() {
            this.endAttr();
        }

        public void beginArrayAttr(String name) {
            this.beginAttr(name);
        }

        public void endArrayAttr() {
            this.endAttr();
        }

        private void beginAttr(String name) {
            if (this.scopeStack != null) {
                String scope = this.scopeStack.isEmpty() ? name : this.scopeStack.peek() + "." + name;
                this.scopeStack.push(scope);
            }
        }

        private void endAttr() {
            if (this.scopeStack != null) {
                this.scopeStack.pop();
            }
        }
    }

    public static class ExcludeExceptFilter
    extends AttrsFilter {
        public ExcludeExceptFilter(Locale locale, String attrsString) throws Exception {
            super(locale, attrsString, true);
        }

        @Override
        protected Result foundResult() {
            return Result.Deferr;
        }

        @Override
        protected Result notFoundResult() {
            return Result.Exclude;
        }
    }

    public static class IncludeExceptFilter
    extends AttrsFilter {
        public IncludeExceptFilter(Locale locale, String attrsString) throws Exception {
            super(locale, attrsString, false);
        }

        @Override
        protected Result foundResult() {
            return Result.Deferr;
        }

        @Override
        protected Result notFoundResult() {
            return Result.Include;
        }
    }

    public static class ExcludeFilter
    extends AttrsFilter {
        public ExcludeFilter(Locale locale, String attrsString) throws Exception {
            super(locale, attrsString, false);
        }

        @Override
        protected Result foundResult() {
            return Result.Exclude;
        }

        @Override
        protected Result notFoundResult() {
            return Result.Deferr;
        }
    }

    public static class IncludeFilter
    extends AttrsFilter {
        public IncludeFilter(Locale locale, String attrsString) throws Exception {
            super(locale, attrsString, true);
        }

        @Override
        protected Result foundResult() {
            return Result.Include;
        }

        @Override
        protected Result notFoundResult() {
            return Result.Deferr;
        }
    }

    public static abstract class AttrsFilter
    implements Filter {
        private Set<String> attrs = new HashSet<String>();
        private Set<String> parentAttrs = new HashSet<String>();

        protected AttrsFilter(Locale locale, String attrsString, boolean includeParents) throws Exception {
            for (String attrString : attrsString.split(",")) {
                if (this.attrs.contains(attrString = attrString.trim()) || this.parentAttrs.contains(attrString)) {
                    this.throwOverlappingFieldsException(locale, attrsString);
                }
                this.attrs.add(attrString);
                String parent = "";
                boolean first = true;
                for (String comp : attrString.split("\\.")) {
                    parent = this.processParentComponent(locale, attrsString, attrString, parent, comp.trim(), first);
                    first = false;
                }
            }
            if (!includeParents) {
                this.parentAttrs.clear();
            }
        }

        private String processParentComponent(Locale locale, String attrsString, String attrString, String parent, String comp, boolean first) throws Exception {
            StringBuilder sb = new StringBuilder();
            sb.append(parent);
            if (!first) {
                sb.append(".");
            }
            sb.append(comp);
            parent = sb.toString();
            if (!parent.equals(attrString)) {
                if (this.attrs.contains(parent)) {
                    this.throwOverlappingFieldsException(locale, attrsString);
                }
                this.parentAttrs.add(parent);
            }
            return parent;
        }

        private void throwOverlappingFieldsException(Locale locale, String attrs) throws Exception {
            String msg = localStrings.getLocalString("filter.overLappingFieldsSpecified", "The field names must not overlap or be specified more than once: {0}", new Object[]{attrs});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).build());
        }

        @Override
        public Result filter(String attr) {
            if (this.attrs.contains(attr) || this.parentAttrs.contains(attr)) {
                return this.foundResult();
            }
            for (String a : this.attrs) {
                if (!attr.startsWith(a + ".")) continue;
                return this.foundResult();
            }
            return this.notFoundResult();
        }

        protected abstract Result foundResult();

        protected abstract Result notFoundResult();
    }

    public static class IdentityFilter
    implements Filter {
        private String identityAttr;

        public IdentityFilter(String identityAttr) {
            this.identityAttr = identityAttr;
        }

        @Override
        public Result filter(String attr) {
            if (this.identityAttr.equals(attr)) {
                return Result.Include;
            }
            return Result.Deferr;
        }
    }

    public static interface Filter {
        public Result filter(String var1);
    }

    protected static enum Result {
        Exclude,
        Include,
        Deferr;

    }
}

