/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.Content;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;

public class RestrictedContentAdapter
extends HttpHandler {
    public static final String LAST_MODIFIED_HEADER_NAME = "Last-Modified";
    public static final String DATE_HEADER_NAME = "Date";
    protected static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String BROKEN_PIPE = "Broken pipe";
    protected static final Logger logger = Logger.getLogger("jakarta.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
    private volatile State state = State.RESUMED;
    private final String contextRoot;
    private final ConcurrentHashMap<String, StaticContent> content = new ConcurrentHashMap();

    public RestrictedContentAdapter(String contextRoot, Map<String, StaticContent> content) throws IOException {
        this(contextRoot);
        this.content.putAll(content);
        logger.log(Level.FINE, "{0}Initial static content loaded {1}", new Object[]{this.logPrefix(), this.dumpContent()});
    }

    public RestrictedContentAdapter(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void service(Request gReq, Response gResp) {
        try {
            if (!this.serviceContent(gReq, gResp)) {
                this.respondNotFound(gResp);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String contextRoot() {
        return this.contextRoot;
    }

    public synchronized void addContentIfAbsent(String relativeURIString, StaticContent newContent) throws IOException {
        StaticContent existingContent = this.content.get(relativeURIString);
        if (existingContent != null) {
            if (!existingContent.equals(newContent)) {
                logger.log(Level.FINE, "enterprise.deployment.appclient.jws.staticContentCollision", new Object[]{relativeURIString, newContent.toString()});
            }
            return;
        }
        this.content.put(relativeURIString, newContent);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.logPrefix() + "adding static content " + relativeURIString + " " + newContent.toString());
        }
    }

    public synchronized void addContentIfAbsent(Map<String, StaticContent> staticContent) throws IOException {
        for (Map.Entry<String, StaticContent> entry : staticContent.entrySet()) {
            this.addContentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    protected String relativizeURIString(String candidateContextRoot, String uriString) {
        if (!uriString.startsWith(candidateContextRoot)) {
            return null;
        }
        if (candidateContextRoot.equals(uriString)) {
            return "";
        }
        return uriString.substring(candidateContextRoot.length() + 1);
    }

    protected boolean serviceContent(Request gReq, Response gResp) throws IOException {
        String scStateString;
        String relativeURIString = this.relativizeURIString(this.contextRoot, gReq.getRequestURI());
        if (this.state == State.SUSPENDED) {
            this.finishErrorResponse(gResp, 403);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.logPrefix() + "is suspended; refused to serve static content requested using " + (relativeURIString == null ? "null" : relativeURIString));
            }
            return true;
        }
        if (relativeURIString == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.logPrefix() + "Could not find static content requested using full request URI = " + gReq.getRequestURI() + " - relativized URI was null");
            }
            this.respondNotFound(gResp);
            return true;
        }
        StaticContent sc = this.content.get(relativeURIString);
        URI requestURI = Util.getCodebase(gReq);
        if (sc != null && sc.isAvailable(requestURI)) {
            this.processContent(relativeURIString, gReq, gResp);
            return true;
        }
        this.finishErrorResponse(gResp, this.contentStateToResponseStatus(sc, requestURI));
        String scString = sc == null ? "null" : sc.toString();
        String string = scStateString = sc == null ? "null" : sc.state().toString();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.logPrefix() + "Found static content for " + gReq.getMethod() + ": " + relativeURIString + " -> " + scString + " but could not serve it; its state is " + scStateString);
        }
        return true;
    }

    private void processContent(String relativeURIString, Request gReq, Response gResp) {
        try {
            StaticContent sc = this.content.get(relativeURIString);
            if (sc == null) {
                throw new RuntimeException(relativeURIString + "-> null");
            }
            File fileToSend = sc.file();
            if (fileToSend != null && this.returnIfClientCacheIsCurrent(relativeURIString, gReq, fileToSend.lastModified())) {
                return;
            }
            sc.process(relativeURIString, gReq, gResp);
        }
        catch (IOException ioex) {
            if (this.isBrokenPipe(ioex)) {
                logger.log(Level.FINE, "''Broken pipe'' while responding to {0}{1}", new Object[]{this.logPrefix(), relativeURIString});
            } else {
                this.finishErrorResponse(gResp, 500);
                logger.log(Level.SEVERE, this.logPrefix() + relativeURIString, ioex);
            }
        }
        catch (Exception e) {
            this.finishErrorResponse(gResp, 500);
            logger.log(Level.SEVERE, this.logPrefix() + relativeURIString, e);
        }
    }

    private boolean isBrokenPipe(IOException ioex) {
        Throwable cause = ioex.getCause();
        return cause != null && cause instanceof IOException && cause.getMessage().contains(BROKEN_PIPE);
    }

    protected boolean returnIfClientCacheIsCurrent(String relativeURIString, Request gReq, long contentTimestamp) {
        long ifModifiedSinceTime = gReq.getDateHeader(IF_MODIFIED_SINCE);
        boolean result = ifModifiedSinceTime != -1L && ifModifiedSinceTime >= contentTimestamp;
        if (result) {
            this.finishSuccessResponse(gReq.getResponse(), 304);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.logPrefix() + relativeURIString + " is already current on the client; no downloaded needed");
            }
        }
        return result;
    }

    protected int contentStateToResponseStatus(Content content, URI requestURI) throws IOException {
        int status = content == null ? 404 : (content.isAvailable(requestURI) ? 200 : (content.state() == Content.State.SUSPENDED ? 403 : 404));
        return status;
    }

    public void suspend() {
        this.state = State.SUSPENDED;
    }

    public void resume() {
        this.state = State.RESUMED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.logPrefix()).append(LINE_SEP);
        for (Map.Entry<String, StaticContent> entry : this.content.entrySet()) {
            sb.append("  ").append(entry.toString()).append(LINE_SEP);
        }
        return sb.toString();
    }

    protected void finishResponse(Response gResp, int status) {
        gResp.setStatus(status);
        gResp.finish();
    }

    protected void respondNotFound(Response gResp) {
        this.finishErrorResponse(gResp, 404);
    }

    protected void finishSuccessResponse(Response gResp, int status) {
        this.finishResponse(gResp, status, false);
    }

    private void finishResponse(Response gResp, int status, boolean treatAsError) {
        if (gResp.isCommitted() || !gResp.getRequest().getContext().getConnection().isOpen()) {
            return;
        }
        gResp.setStatus(status);
        try {
            if (treatAsError) {
                gResp.sendError(status);
            }
            gResp.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void finishErrorResponse(Response gResp, int status) {
        this.finishResponse(gResp, status, true);
    }

    protected String dumpContent() {
        if (this.content == null) {
            return "  Static content: not initialized";
        }
        if (this.content.isEmpty()) {
            return "  Static content: empty" + LINE_SEP;
        }
        StringBuilder sb = new StringBuilder(LINE_SEP).append("  Static content");
        for (Map.Entry<String, StaticContent> entry : this.content.entrySet()) {
            sb.append("  ").append(entry.getKey()).append(" : ").append(entry.getValue().toString()).append(LINE_SEP);
        }
        sb.append(LINE_SEP).append("  ========");
        return sb.toString();
    }

    protected String logPrefix() {
        return "Adapter[" + this.contextRoot + "] ";
    }

    private static enum State {
        RESUMED,
        SUSPENDED;

    }
}

