/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.tree.BinaryArithmeticExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.DoubleExpression;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.FloatExpression;
import org.glassfish.rmic.tools.tree.IntExpression;
import org.glassfish.rmic.tools.tree.LongExpression;

public class MultiplyExpression
extends BinaryArithmeticExpression {
    public MultiplyExpression(long where, Expression left, Expression right) {
        super(33, where, left, right);
    }

    @Override
    Expression eval(int a, int b) {
        return new IntExpression(this.where, a * b);
    }

    @Override
    Expression eval(long a, long b) {
        return new LongExpression(this.where, a * b);
    }

    @Override
    Expression eval(float a, float b) {
        return new FloatExpression(this.where, a * b);
    }

    @Override
    Expression eval(double a, double b) {
        return new DoubleExpression(this.where, a * b);
    }

    @Override
    Expression simplify() {
        if (this.left.equals(1)) {
            return this.right;
        }
        if (this.right.equals(1)) {
            return this.left;
        }
        return this;
    }

    @Override
    void codeOperation(Environment env, Context ctx, Assembler asm) {
        asm.add(this.where, 104 + this.type.getTypeCodeOffset());
    }
}

