/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.codegen.AsmSerializableBeanGenerator;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalObjectInvocationHandlerDelegate;
import com.sun.ejb.spi.container.OptionalLocalInterfaceProvider;
import com.sun.enterprise.deployment.EjbInterceptor;
import jakarta.ejb.EJBException;
import jakarta.ejb.NoSuchEJBException;
import jakarta.ejb.RemoveException;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.logging.Level;
import org.glassfish.ejb.LogFacade;
import org.glassfish.ejb.api.EjbContainerServices;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
public class EjbContainerServicesImpl
implements EjbContainerServices {
    public <S> S getBusinessObject(Object ejbRef, Class<S> businessInterface) {
        EJBLocalObjectImpl localObjectImpl = this.getEJBLocalObject(ejbRef);
        if (localObjectImpl == null) {
            throw new IllegalStateException("Invalid ejb ref");
        }
        Container container = localObjectImpl.getContainer();
        EjbDescriptor ejbDesc = container.getEjbDescriptor();
        Object businessObject = null;
        if (businessInterface != null) {
            String intfName = businessInterface.getName();
            if (ejbDesc.getLocalBusinessClassNames().contains(intfName)) {
                businessObject = localObjectImpl.getClientObject(intfName);
            } else if (ejbDesc.isLocalBean()) {
                boolean isValidBusinessInterface = ejbDesc.getNoInterfaceLocalBeanClasses().contains(intfName);
                if (intfName.equals(ejbDesc.getEjbClassName()) || isValidBusinessInterface) {
                    businessObject = localObjectImpl.getClientObject(ejbDesc.getEjbClassName());
                }
            }
        }
        if (businessObject == null) {
            throw new IllegalStateException("Unable to convert ejbRef for ejb " + ejbDesc.getName() + " to a business object of type " + businessInterface);
        }
        return (S)businessObject;
    }

    public void remove(Object ejbRef) {
        EJBLocalObjectImpl localObjectImpl = this.getEJBLocalObject(ejbRef);
        if (localObjectImpl == null) {
            throw new UnsupportedOperationException("Invalid ejb ref");
        }
        Container container = localObjectImpl.getContainer();
        EjbDescriptor ejbDesc = container.getEjbDescriptor();
        boolean isStatefulBean = false;
        if (ejbDesc.getType().equals("Session")) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejbDesc;
            isStatefulBean = sessionDesc.isStateful();
        }
        if (!isStatefulBean) {
            return;
        }
        try {
            localObjectImpl.remove();
        }
        catch (EJBException e) {
            LogFacade.getLogger().log(Level.FINE, "EJBException during remove. ", e);
        }
        catch (RemoveException re) {
            throw new NoSuchEJBException(re.getMessage(), re);
        }
    }

    public boolean isRemoved(Object ejbRef) {
        EJBLocalObjectImpl localObjectImpl = this.getEJBLocalObject(ejbRef);
        if (localObjectImpl == null) {
            throw new UnsupportedOperationException("Invalid ejb ref");
        }
        Container container = localObjectImpl.getContainer();
        EjbDescriptor ejbDesc = container.getEjbDescriptor();
        boolean isStatefulBean = false;
        if (ejbDesc.getType().equals("Session")) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejbDesc;
            isStatefulBean = sessionDesc.isStateful();
        }
        if (!isStatefulBean) {
            return false;
        }
        boolean removed = false;
        try {
            ((BaseContainer)container).checkExists(localObjectImpl);
        }
        catch (Exception e) {
            removed = true;
        }
        return removed;
    }

    private EJBLocalObjectImpl getEJBLocalObject(Object ejbRef) {
        EJBLocalObjectInvocationHandlerDelegate localObj;
        block6: {
            localObj = null;
            try {
                localObj = (EJBLocalObjectInvocationHandlerDelegate)Proxy.getInvocationHandler(ejbRef);
            }
            catch (IllegalArgumentException iae) {
                Proxy proxy;
                if (!(ejbRef instanceof OptionalLocalInterfaceProvider)) break block6;
                try {
                    Field proxyField;
                    final Field finalF = proxyField = ejbRef.getClass().getDeclaredField("__ejb31_delegate");
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (!finalF.isAccessible()) {
                                finalF.setAccessible(true);
                            }
                            return null;
                        }
                    });
                    proxy = (Proxy)proxyField.get(ejbRef);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid ejb ref", e);
                }
                try {
                    localObj = (EJBLocalObjectInvocationHandlerDelegate)Proxy.getInvocationHandler(proxy);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return localObj != null ? localObj.getDelegate() : null;
    }

    public boolean isEjbManagedObject(Object desc, Class c) {
        String className = c.getName();
        EjbDescriptor ejbDesc = (EjbDescriptor)((Object)desc);
        HashSet<String> ejbManagedObjectClassNames = new HashSet<String>();
        ejbManagedObjectClassNames.add(ejbDesc.getEjbClassName());
        for (EjbInterceptor ejbInterceptor : ejbDesc.getInterceptorClasses()) {
            if (ejbInterceptor.isCDIInterceptor()) continue;
            ejbManagedObjectClassNames.add(ejbInterceptor.getInterceptorClassName());
        }
        HashSet<String> serializableClassNames = new HashSet<String>();
        for (String next : ejbManagedObjectClassNames) {
            serializableClassNames.add(AsmSerializableBeanGenerator.getGeneratedSerializableClassName(next));
        }
        boolean bl = ejbManagedObjectClassNames.contains(className) || serializableClassNames.contains(className);
        return bl;
    }
}

