/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.MessageTransformer;
import com.sun.messaging.bridge.api.StompDestination;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompMessage;
import com.sun.messaging.bridge.api.StompSession;
import com.sun.messaging.bridge.service.stomp.StompConnectionImpl;
import com.sun.messaging.bridge.service.stomp.StompDestinationImpl;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StompSenderSession
implements StompSession {
    protected Logger logger = null;
    protected StompBridgeResources sbr = StompServer.getStompBridgeResources();
    protected Session session = null;
    protected boolean closed = false;
    protected MessageProducer producer = null;
    protected StompConnectionImpl stompconn = null;
    protected Connection connection = null;

    public StompSenderSession(StompConnectionImpl stompc) throws Exception {
        this.stompconn = stompc;
        this.logger = stompc.getProtocolHandler().getLogger();
        this.connection = this.stompconn.getConnection();
        this.session = this.createSession();
        this.producer = this.session.createProducer(null);
    }

    protected Session createSession() throws JMSException {
        return this.connection.createSession(false, 0);
    }

    protected Session getJMSSession() throws Exception {
        this.checkSession();
        return this.session;
    }

    public void sendStompMessage(StompFrameMessage message) throws Exception {
        this.checkSession();
        MessageTransformer mt = this.stompconn.getProtocolHandler().getMessageTransformer();
        StompMessageImpl msg = new StompMessageImpl(mt);
        this.stompconn.getProtocolHandler().fromStompFrameMessage(message, msg);
        Message jmsmsg = msg.jmsmsg;
        Destination jmsdest = msg.jmsdest;
        if (mt != null) {
            mt.init(this.session, "STOMP");
            jmsmsg = (Message)mt.transform(jmsmsg, false, "UTF-8", "STOMP", "SUN_MQ", msg.propsForTransformer);
            if (jmsmsg == null) {
                throw new JMSException("null returned from " + mt.getClass().getName() + " transform() method");
            }
        }
        this.producer.send(jmsdest, jmsmsg, jmsmsg.getJMSDeliveryMode(), jmsmsg.getJMSPriority(), jmsmsg.getJMSExpiration());
        this.logger.log(Level.FINE, "Sent message " + jmsmsg.getJMSMessageID());
    }

    public void close() throws Exception {
        this.session.close();
        this.closed = true;
    }

    protected void checkSession() throws Exception {
        if (this.closed) {
            throw new JMSException(StompServer.getStompBridgeResources().getKString("BSS4023"));
        }
    }

    @Override
    public StompDestination createStompDestination(String name, boolean isQueue) throws Exception {
        if (isQueue) {
            return new StompDestinationImpl((Destination)this.session.createQueue(name));
        }
        return new StompDestinationImpl((Destination)this.session.createTopic(name));
    }

    @Override
    public StompDestination createTempStompDestination(boolean isQueue) throws Exception {
        if (isQueue) {
            return new StompDestinationImpl((Destination)this.session.createTemporaryQueue());
        }
        return new StompDestinationImpl((Destination)this.session.createTemporaryTopic());
    }

    class StompMessageImpl
    implements StompMessage {
        Message jmsmsg = null;
        Destination jmsdest = null;
        MessageTransformer mt = null;
        Properties propsForTransformer = null;

        public StompMessageImpl(MessageTransformer mt) {
            this.mt = mt;
        }

        @Override
        public void setText(StompFrameMessage message) throws Exception {
            this.jmsmsg = StompSenderSession.this.session.createTextMessage();
            ((TextMessage)this.jmsmsg).setText(message.getBodyText());
        }

        @Override
        public void setBytes(StompFrameMessage message) throws Exception {
            this.jmsmsg = StompSenderSession.this.session.createBytesMessage();
            ((BytesMessage)this.jmsmsg).writeBytes(message.getBody());
        }

        @Override
        public void setDestination(String stompdest) throws Exception {
            StompDestination d = StompSenderSession.this.stompconn.getProtocolHandler().toStompDestination(stompdest, StompSenderSession.this, false);
            this.jmsdest = ((StompDestinationImpl)d).getJMSDestination();
        }

        @Override
        public void setReplyTo(String replyto) throws Exception {
            if (replyto == null) {
                return;
            }
            StompDestination dr = StompSenderSession.this.stompconn.getProtocolHandler().toStompDestination(replyto, StompSenderSession.this, false);
            Destination jmsdestr = ((StompDestinationImpl)dr).getJMSDestination();
            this.jmsmsg.setJMSReplyTo(jmsdestr);
        }

        @Override
        public void setPersistent(String v) throws Exception {
            if (v == null) {
                return;
            }
            int deliveryMode = Boolean.valueOf(v) != false ? 2 : 1;
            this.jmsmsg.setJMSDeliveryMode(deliveryMode);
        }

        @Override
        public void setJMSExpiration(String v) throws Exception {
            if (v == null) {
                return;
            }
            long timeToLive = Long.parseLong(v);
            if (timeToLive != 0L) {
                this.jmsmsg.setJMSExpiration(timeToLive);
            }
        }

        @Override
        public void setJMSPriority(String v) throws Exception {
            if (v == null) {
                return;
            }
            int pri = Integer.parseInt(v);
            this.jmsmsg.setJMSPriority(pri);
        }

        @Override
        public void setJMSCorrelationID(String v) throws Exception {
            if (v != null) {
                this.jmsmsg.setJMSCorrelationID(v);
            }
        }

        @Override
        public void setJMSType(String v) throws Exception {
            if (v != null) {
                this.jmsmsg.setJMSType(v);
            }
        }

        @Override
        public void setProperty(String name, String value) throws Exception {
            try {
                this.jmsmsg.setStringProperty(name, value);
            }
            catch (JMSException e) {
                if (this.mt == null) {
                    throw e;
                }
                this.propsForTransformer = new Properties();
                this.propsForTransformer.setProperty(name, value);
                String h = name + "=" + value;
                if (StompSenderSession.this.logger.isLoggable(Level.FINE)) {
                    StompBridgeResources cfr_ignored_0 = StompSenderSession.this.sbr;
                    StompSenderSession.this.logger.log(Level.WARNING, StompSenderSession.this.sbr.getKString("BSS2004", h, e.getMessage()), e);
                } else {
                    StompBridgeResources cfr_ignored_1 = StompSenderSession.this.sbr;
                    StompSenderSession.this.logger.log(Level.WARNING, StompSenderSession.this.sbr.getKString("BSS2004", h, e.getMessage()));
                }
                StompBridgeResources cfr_ignored_2 = StompSenderSession.this.sbr;
                StompSenderSession.this.logger.log(Level.INFO, StompSenderSession.this.sbr.getString("BSS1009", h, this.mt.getClass().getName()));
            }
        }

        @Override
        public String getSubscriptionID() throws Exception {
            throw new RuntimeException("Unexpected call: getSubscriptionID()");
        }

        @Override
        public String getDestination() throws Exception {
            throw new RuntimeException("Unexpected call: getDestination()");
        }

        @Override
        public String getReplyTo() throws Exception {
            throw new RuntimeException("Unexpected call: getReplyTo()");
        }

        @Override
        public String getJMSMessageID() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSMessageID()");
        }

        @Override
        public String getJMSCorrelationID() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSCorrelationID()");
        }

        @Override
        public String getJMSExpiration() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSExpiration()");
        }

        @Override
        public String getJMSRedelivered() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSRedelivered()");
        }

        @Override
        public String getJMSPriority() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSPriority()");
        }

        @Override
        public String getJMSTimestamp() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSTimestamp()");
        }

        @Override
        public String getJMSType() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSType()");
        }

        @Override
        public Enumeration getPropertyNames() throws Exception {
            throw new RuntimeException("Unexpected call: getPropertyNames()");
        }

        @Override
        public String getProperty(String name) throws Exception {
            throw new RuntimeException("Unexpected call: getProperty()");
        }

        @Override
        public boolean isTextMessage() throws Exception {
            throw new RuntimeException("Unexpected call: isTextMessage()");
        }

        @Override
        public boolean isBytesMessage() throws Exception {
            throw new RuntimeException("Unexpected call: isBytesMessage()");
        }

        @Override
        public String getText() throws Exception {
            throw new RuntimeException("Unexpected call: getText()");
        }

        @Override
        public byte[] getBytes() throws Exception {
            throw new RuntimeException("Unexpected call: getBytes()");
        }
    }
}

