/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.glassfish.appclient.common.ClassPathUtils;
import org.glassfish.appclient.common.ClientClassLoaderDelegate;

public class ACCClassLoader
extends URLClassLoader {
    private static final String AGENT_LOADER_CLASS_NAME = "org.glassfish.appclient.client.acc.agent.ACCAgentClassLoader";
    private static ACCClassLoader instance;
    private ACCClassLoader shadow;
    private boolean shouldTransform;
    private final List<ClassFileTransformer> transformers = Collections.synchronizedList(new ArrayList());
    private ClientClassLoaderDelegate clientCLDelegate;

    public static synchronized ACCClassLoader newInstance(ClassLoader parent, final boolean shouldTransform) {
        if (instance != null) {
            throw new IllegalStateException("already set");
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean currentCLWasAgentCL = currentClassLoader.getClass().getName().equals(AGENT_LOADER_CLASS_NAME);
        final ClassLoader parentForACCCL = currentCLWasAgentCL ? currentClassLoader.getParent() : currentClassLoader;
        instance = AccessController.doPrivileged(new PrivilegedAction<ACCClassLoader>(){

            @Override
            public ACCClassLoader run() {
                URL[] classpath = ClassPathUtils.getJavaClassPathForAppClient();
                return new ACCClassLoader(classpath, parentForACCCL, shouldTransform);
            }
        });
        if (currentCLWasAgentCL) {
            try {
                ACCClassLoader.adjustACCAgentClassLoaderParent(instance);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return instance;
    }

    public static ACCClassLoader instance() {
        return instance;
    }

    private static void adjustACCAgentClassLoaderParent(ACCClassLoader instance) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader.getClass().getName().equals(AGENT_LOADER_CLASS_NAME) && systemClassLoader instanceof Consumer) {
            Consumer consumerOfClassLoader = (Consumer)((Object)systemClassLoader);
            consumerOfClassLoader.accept(instance);
            System.setProperty("org.glassfish.appclient.acc.agentLoaderDone", "true");
        }
    }

    public ACCClassLoader(ClassLoader parent, boolean shouldTransform) {
        super(new URL[0], parent);
        this.shouldTransform = shouldTransform;
        this.clientCLDelegate = new ClientClassLoaderDelegate(this);
    }

    public ACCClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.clientCLDelegate = new ClientClassLoaderDelegate(this);
    }

    private ACCClassLoader(URL[] urls, ClassLoader parent, boolean shouldTransform) {
        this(urls, parent);
        this.shouldTransform = shouldTransform;
    }

    public synchronized void appendURL(URL url) {
        this.addURL(url);
        if (this.shadow != null) {
            this.shadow.addURL(url);
        }
    }

    public void addTransformer(ClassFileTransformer xf) {
        this.transformers.add(xf);
    }

    public void setShouldTransform(boolean shouldTransform) {
        this.shouldTransform = shouldTransform;
    }

    synchronized ACCClassLoader shadow() {
        if (this.shadow == null) {
            this.shadow = AccessController.doPrivileged(new PrivilegedAction<ACCClassLoader>(){

                @Override
                public ACCClassLoader run() {
                    return new ACCClassLoader(ACCClassLoader.this.getURLs(), ACCClassLoader.this.getParent());
                }
            });
        }
        return this.shadow;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this.shouldTransform) {
            return super.findClass(name);
        }
        return this.copyClass(this.shadow().findClassUnshadowed(name));
    }

    private Class<?> copyClass(Class<?> sourceClass) throws ClassNotFoundException {
        String name = sourceClass.getName();
        ProtectionDomain pd = sourceClass.getProtectionDomain();
        byte[] bytecode = this.readByteCode(name);
        for (ClassFileTransformer xf : this.transformers) {
            try {
                bytecode = xf.transform(this, name, null, pd, bytecode);
            }
            catch (IllegalClassFormatException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        return this.defineClass(name, bytecode, 0, bytecode.length, pd);
    }

    private Class<?> findClassUnshadowed(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private byte[] readByteCode(String className) throws ClassNotFoundException {
        String resourceName = className.replace('.', '/') + ".class";
        InputStream is = this.getResourceAsStream(resourceName);
        if (is == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8196];
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(className, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className, e);
            }
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        if (System.getSecurityManager() == null) {
            return super.getPermissions(codesource);
        }
        if (this.clientCLDelegate.getCachedPerms(codesource) != null) {
            return this.clientCLDelegate.getCachedPerms(codesource);
        }
        return this.clientCLDelegate.getPermissions(codesource, super.getPermissions(codesource));
    }

    public void processDeclaredPermissions() throws IOException {
        if (this.clientCLDelegate == null) {
            this.clientCLDelegate = new ClientClassLoaderDelegate(this);
        }
    }
}

