/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.injection;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSPasswordCredential;
import jakarta.jms.JMSSessionMode;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.RelativePathResolver;

public class JMSContextMetadata
implements Serializable {
    private static final Logger logger = Logger.getLogger("jakarta.enterprise.resource.jms.injection");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JMSContextMetadata.class);
    public static final String DEFAULT_CONNECTION_FACTORY = "java:comp/DefaultJMSConnectionFactory";
    private final String lookup;
    private final int sessionMode;
    private final String userName;
    private final String password;
    private String fingerPrint;

    JMSContextMetadata(JMSConnectionFactory jmsConnectionFactoryAnnot, JMSSessionMode sessionModeAnnot, JMSPasswordCredential credentialAnnot) {
        this.lookup = jmsConnectionFactoryAnnot == null ? null : jmsConnectionFactoryAnnot.value().trim();
        this.sessionMode = sessionModeAnnot == null ? 1 : sessionModeAnnot.value();
        if (credentialAnnot == null) {
            this.userName = null;
            this.password = null;
        } else {
            this.userName = credentialAnnot.userName();
            this.password = this.getUnAliasedPwd(credentialAnnot.password());
        }
    }

    public String getLookup() {
        return this.lookup;
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("JMSContextMetadata[");
        sb.append("lookup=").append(this.lookup);
        sb.append(", sessionMode=").append(this.sessionMode);
        sb.append(", username=").append(this.userName);
        sb.append(", password=");
        if (this.password != null) {
            sb.append("xxxxxx");
        } else {
            sb.append("null");
        }
        sb.append(" [fingerPrint[").append(this.getFingerPrint());
        sb.append("]]");
        return sb.toString();
    }

    public String getFingerPrint() {
        if (this.fingerPrint == null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte delimer = 124;
                md.update(delimer);
                String cf = this.lookup;
                if (this.lookup == null) {
                    cf = DEFAULT_CONNECTION_FACTORY;
                }
                md.update(cf.getBytes("ISO-8859-1"));
                md.update(delimer);
                md.update((byte)this.sessionMode);
                md.update(delimer);
                if (this.userName != null) {
                    md.update(this.userName.getBytes("ISO-8859-1"));
                }
                md.update(delimer);
                if (this.password != null) {
                    md.update(this.password.getBytes("ISO-8859-1"));
                }
                md.update(delimer);
                byte[] result = md.digest();
                StringBuffer buff = new StringBuffer();
                for (int i = 0; i < result.length; ++i) {
                    String byteStr = Integer.toHexString(result[i] & 0xFF);
                    if (byteStr.length() < 2) {
                        buff.append('0');
                    }
                    buff.append(byteStr);
                }
                this.fingerPrint = buff.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't make digest of JMSContextMetadata content", e);
            }
        }
        return this.fingerPrint;
    }

    private boolean isPasswordAlias(String password) {
        return password != null && password.startsWith("${ALIAS=");
    }

    private String getUnAliasedPwd(String password) {
        block4: {
            if (password != null && this.isPasswordAlias(password)) {
                try {
                    String unalisedPwd = RelativePathResolver.getRealPasswordFromAlias(password);
                    if (unalisedPwd != null && !"".equals(unalisedPwd)) {
                        return unalisedPwd;
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.log(Level.WARNING, localStrings.getLocalString("decrypt.password.fail", "Failed to unalias password for the reason: {0}."), e.toString());
                }
            }
        }
        return password;
    }
}

