/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.locked;

import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import org.glassfish.exousia.modules.locked.SimplePolicyConfiguration;

public class SimplePolicyProvider
extends Policy {
    private static final String REUSE = "java.security.Policy.supportsReuse";
    private Policy basePolicy = Policy.getPolicy();
    private static ThreadLocal<Object> reentrancyStatus = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            return new byte[]{0};
        }
    };

    public SimplePolicyProvider() {
        if (this.basePolicy == null) {
            try {
                this.basePolicy = Policy.getInstance("JavaPolicy", null);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection permissionCollection = this.basePolicy.getPermissions(codesource);
        try {
            permissionCollection = SimplePolicyConfiguration.getPermissions(permissionCollection, codesource);
        }
        catch (PolicyContextException pce) {
            SimplePolicyConfiguration.logGetPermissionsFailure(codesource, pce);
        }
        return permissionCollection;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection permissionCollection = this.basePolicy.getPermissions(domain);
        try {
            permissionCollection = SimplePolicyConfiguration.getPermissions(permissionCollection, domain);
        }
        catch (PolicyContextException pce) {
            SimplePolicyConfiguration.logGetPermissionsFailure(domain, pce);
        }
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        byte[] alreadyCalled = (byte[])reentrancyStatus.get();
        if (alreadyCalled[0] == 1) {
            return true;
        }
        alreadyCalled[0] = 1;
        try {
            boolean bl = this.doImplies(domain, permission);
            return bl;
        }
        finally {
            alreadyCalled[0] = 0;
        }
    }

    private boolean doImplies(ProtectionDomain domain, Permission permission) {
        int implies;
        block5: {
            implies = -1;
            try {
                implies = SimplePolicyConfiguration.implies(domain, permission);
                if (implies > 0) {
                    return true;
                }
            }
            catch (PolicyContextException pce) {
                if (implies == 0) break block5;
                implies = 1;
            }
        }
        boolean doImplies = false;
        if (implies == 0) {
            doImplies = this.basePolicy.implies(domain, permission);
        }
        if (!doImplies) {
            SimplePolicyConfiguration.logAccessFailure(domain, permission);
        }
        return doImplies;
    }

    @Override
    public void refresh() {
        this.basePolicy.refresh();
        try {
            boolean supportsReuse;
            String propValue = System.getProperty(REUSE);
            boolean bl = supportsReuse = propValue == null ? true : Boolean.valueOf(propValue);
            if (supportsReuse && PolicyContext.getHandlerKeys().contains(REUSE)) {
                PolicyContext.getContext((String)REUSE);
            }
            SimplePolicyConfiguration.refresh();
        }
        catch (PolicyContextException pce) {
            SimplePolicyConfiguration.logException(Level.SEVERE, "refresh.failure", pce);
            throw new IllegalStateException(pce);
        }
    }
}

