/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.Transaction;
import jakarta.transaction.Transactional;
import jakarta.transaction.TransactionalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.NOT_SUPPORTED)
public class TransactionalInterceptorNotSupported
extends TransactionalInterceptorBase {
    private static final long serialVersionUID = 2905721637911698354L;
    private static final Logger _logger = Logger.getLogger("jakarta.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.log(Level.INFO, "AS-JTA-00006");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(true);
        try {
            Transaction transaction = null;
            if (this.getTransactionManager().getTransaction() != null) {
                _logger.log(Level.INFO, "AS-JTA-00007");
                try {
                    transaction = this.getTransactionManager().suspend();
                }
                catch (Exception exception) {
                    _logger.log(Level.INFO, "AS-JTA-00008", exception);
                    throw new TransactionalException("Managed bean with Transactional annotation and TxType of NOT_SUPPORTED called inside a transaction context.  Suspending transaction failed due to " + exception, (Throwable)exception);
                }
            }
            Object proceed = null;
            try {
                proceed = this.proceed(ctx);
            }
            finally {
                if (transaction != null) {
                    try {
                        this.getTransactionManager().resume(transaction);
                    }
                    catch (Exception exception) {
                        throw new TransactionalException("Managed bean with Transactional annotation and TxType of NOT_SUPPORTED encountered exception during resume " + exception, (Throwable)exception);
                    }
                }
            }
            Object object = proceed;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

