/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.EndpointConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public class DirectMessageListener
implements MessageListener {
    private DirectConnection dc;
    private Method onMessageMethod;
    private boolean isDeliveryTransacted = false;
    private int maxRedeliverCount = 1;
    private MessageEndpoint msgEndpoint = null;
    private DirectXAResource dxar = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectMessageListener";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_DML";
    protected static final transient String _lgrMID_EET = "MQJMSRA_DML1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_DML1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_DML2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_DML3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_DML4001: ";

    public DirectMessageListener(EndpointConsumer epConsumer, MessageEndpointFactory epFactory, DirectConnection dc, Method onMessageMethod, boolean isDeliveryTransacted, int maxRedeliverCount, boolean noAckDelivery) {
        Object[] params = new Object[]{epConsumer, epFactory, dc, onMessageMethod, isDeliveryTransacted, maxRedeliverCount, noAckDelivery};
        _loggerIM.entering(_className, "constructor()", params);
        this.dc = dc;
        this.onMessageMethod = onMessageMethod;
        this.isDeliveryTransacted = isDeliveryTransacted;
        this.maxRedeliverCount = maxRedeliverCount;
        this.dxar = new DirectXAResource(this.dc, this.dc._getJMSService(), this.dc.getConnectionId());
        this.dxar._setUsedByMDB(true);
        try {
            this.msgEndpoint = epFactory.createEndpoint((XAResource)this.dxar);
        }
        catch (UnavailableException ex) {
            System.out.println("DirectMessageListener-Exception creating Endpoint:" + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void onMessage(Message jmsMsg) {
        DirectPacket dpMsg = (DirectPacket)jmsMsg;
        boolean redeliver = true;
        int redeliverCount = 0;
        while (redeliver) {
            if (this.isDeliveryTransacted) {
                try {
                    this.msgEndpoint.beforeDelivery(this.onMessageMethod);
                }
                catch (ResourceException | NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                ((MessageListener)this.msgEndpoint).onMessage(jmsMsg);
                redeliver = false;
                try {
                    dpMsg._acknowledgeThisMessageForMDB(this.dxar);
                    this.dxar.setRollback(false, null);
                }
                catch (JMSException ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception rte) {
                if (redeliverCount > this.maxRedeliverCount) {
                    redeliver = false;
                    this.dxar.setRollback(true, rte);
                }
                ++redeliverCount;
            }
            if (!this.isDeliveryTransacted) continue;
            try {
                this.msgEndpoint.afterDelivery();
            }
            catch (ResourceException ex) {
                ex.printStackTrace();
            }
        }
    }
}

