/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageQueue;
import java.util.LinkedList;

class PriorityQueue
implements MessageQueue {
    protected static final int ARRAY_SIZE = 10;
    private LinkedList[] qlist = null;
    protected int qsize = 0;

    public PriorityQueue() {
        this.init();
    }

    protected void init() {
        this.qlist = new LinkedList[10];
        for (int i = 0; i < 10; ++i) {
            this.qlist[i] = null;
        }
    }

    @Override
    public synchronized int size() {
        return this.qsize;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.qsize == 0;
    }

    @Override
    public synchronized void clear() {
        for (int i = 0; i < 10; ++i) {
            this.qlist[i] = null;
        }
        this.qsize = 0;
    }

    @Override
    public synchronized void enqueue(Object nobj) {
        int priority = this.getPriority(nobj);
        if (this.qlist[priority] == null) {
            this.qlist[priority] = new LinkedList();
        }
        this.qlist[priority].add(nobj);
        ++this.qsize;
    }

    @Override
    public synchronized void enqueueFirst(Object nobj) {
        int priority = this.getPriority(nobj);
        if (this.qlist[priority] == null) {
            this.qlist[priority] = new LinkedList();
        }
        this.qlist[priority].addFirst(nobj);
        ++this.qsize;
    }

    protected int getPriority(Object nobj) {
        int priority = 0;
        try {
            if (nobj instanceof ReadOnlyPacket) {
                priority = ((ReadOnlyPacket)nobj).getPriority();
            } else if (nobj instanceof MessageImpl) {
                priority = ((MessageImpl)nobj).getJMSPriority();
            }
        }
        catch (Exception jmse) {
            Debug.printStackTrace(jmse);
        }
        return priority;
    }

    @Override
    public synchronized Object dequeue() {
        Object obj = null;
        for (int index = 9; index >= 0; --index) {
            if (this.qlist[index] == null || this.qlist[index].isEmpty()) continue;
            obj = this.qlist[index].removeFirst();
            --this.qsize;
            index = -1;
        }
        return obj;
    }

    @Override
    public synchronized Object[] toArray() {
        LinkedList list = new LinkedList();
        for (int index = 9; index >= 0; --index) {
            if (this.qlist[index] == null || this.qlist[index].isEmpty()) continue;
            int size = this.qlist[index].size();
            for (int i = 0; i < size; ++i) {
                list.add(this.qlist[index].get(i));
            }
        }
        return list.toArray();
    }

    @Override
    public synchronized boolean remove(Object obj) {
        boolean found = false;
        for (int index = 9; index >= 0 && !found; --index) {
            if (this.qlist[index] == null || this.qlist[index].isEmpty() || !this.qlist[index].contains(obj)) continue;
            found = this.qlist[index].remove(obj);
            --this.qsize;
        }
        return found;
    }
}

