/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.beans.PropertyVetoException;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.javaee.services.CommonResourceProxy;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=DataSourceDefinitionDescriptor.class)
public class DataSourceDefinitionDeployer
implements ResourceDeployer {
    private static Logger _logger = LogDomains.getLogger(DataSourceDefinitionDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    @Inject
    private Provider<CommonResourceProxy> dataSourceDefinitionProxyProvider;
    @Inject
    private Provider<ResourceNamingService> resourceNamingServiceProvider;

    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void deployResource(Object resource) throws Exception {
        DataSourceDefinitionDescriptor desc = (DataSourceDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)JavaEEResourceType.DSDPOOL);
        String resourceName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)desc.getResourceType());
        _logger.log(Level.FINE, () -> "DataSourceDefinitionDeployer.deployResource() : pool-name [" + poolName + "],  resource-name [" + resourceName + "]");
        MyJdbcConnectionPool jdbcConnectionPool = new MyJdbcConnectionPool(desc, poolName);
        this.getDeployer(jdbcConnectionPool).deployResource((Object)jdbcConnectionPool);
        MyJdbcResource jdbcResource = new MyJdbcResource(poolName, resourceName);
        this.getDeployer(jdbcResource).deployResource((Object)jdbcResource);
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void validatePreservedResource(com.sun.enterprise.config.serverbeans.Application oldApp, com.sun.enterprise.config.serverbeans.Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return ((ResourceManagerFactory)this.resourceManagerFactoryProvider.get()).getResourceDeployer(resource);
    }

    private DataSourceProperty convertProperty(String name, String value) {
        return new DataSourceProperty(name, value);
    }

    public void registerDataSourceDefinitions(Application application) {
        String appName = application.getAppName();
        Set bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            this.registerDataSourceDefinitions(appName, (Descriptor)bundle);
            Collection deploymentDescriptors = bundle.getExtensionsDescriptors();
            if (deploymentDescriptors == null) continue;
            for (RootDeploymentDescriptor deploymentDescriptor : deploymentDescriptors) {
                this.registerDataSourceDefinitions(appName, (Descriptor)deploymentDescriptor);
            }
        }
    }

    private void registerDataSourceDefinitions(String appName, Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)descriptor;
            for (Descriptor resourceDescriptor : env.getResourceDescriptors(JavaEEResourceType.DSD)) {
                this.registerDSDReferredByApplication(appName, (DataSourceDefinitionDescriptor)resourceDescriptor);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (Descriptor resourceDescriptor : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.registerDSDReferredByApplication(appName, (DataSourceDefinitionDescriptor)resourceDescriptor);
                }
            }
            Set ejbInterceptors = ejbDesc.getInterceptors();
            for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                for (Descriptor resourceDescriptor : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.registerDSDReferredByApplication(appName, (DataSourceDefinitionDescriptor)resourceDescriptor);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor managedBeanDescriptor : managedBeanDescriptors) {
                for (Descriptor resourceDescriptor : managedBeanDescriptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.registerDSDReferredByApplication(appName, (DataSourceDefinitionDescriptor)resourceDescriptor);
                }
            }
        }
    }

    private void unregisterDSDReferredByApplication(DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor) {
        try {
            if (dataSourceDefinitionDescriptor.isDeployed()) {
                this.undeployResource(dataSourceDefinitionDescriptor);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "exception while unregistering DSD [ " + dataSourceDefinitionDescriptor.getName() + " ]", e);
        }
    }

    public void unRegisterDataSourceDefinitions(Application application) {
        Set bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            this.unRegisterDataSourceDefinitions((Descriptor)bundle);
            Collection deploymentDescriptors = bundle.getExtensionsDescriptors();
            if (deploymentDescriptors == null) continue;
            for (RootDeploymentDescriptor deploymentDescriptor : deploymentDescriptors) {
                this.unRegisterDataSourceDefinitions((Descriptor)deploymentDescriptor);
            }
        }
    }

    private void unRegisterDataSourceDefinitions(Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)descriptor;
            for (Descriptor resourceDescriptor : env.getResourceDescriptors(JavaEEResourceType.DSD)) {
                this.unregisterDSDReferredByApplication((DataSourceDefinitionDescriptor)resourceDescriptor);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (Descriptor resourceDescriptor : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.unregisterDSDReferredByApplication((DataSourceDefinitionDescriptor)resourceDescriptor);
                }
            }
            Set ejbInterceptors = ejbDesc.getInterceptors();
            for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                for (Descriptor resourceDescriptor : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.unregisterDSDReferredByApplication((DataSourceDefinitionDescriptor)resourceDescriptor);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor managedBeanDescriptor : managedBeanDescriptors) {
                for (Descriptor resourceDescriptor : managedBeanDescriptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.unregisterDSDReferredByApplication((DataSourceDefinitionDescriptor)resourceDescriptor);
                }
            }
        }
    }

    private void registerDSDReferredByApplication(String appName, DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor) {
        if (!dataSourceDefinitionDescriptor.isDeployed()) {
            CommonResourceProxy proxy = (CommonResourceProxy)this.dataSourceDefinitionProxyProvider.get();
            ResourceNamingService resourceNamingService = (ResourceNamingService)this.resourceNamingServiceProvider.get();
            proxy.setDescriptor((ResourceDescriptor)dataSourceDefinitionDescriptor);
            String dsdName = dataSourceDefinitionDescriptor.getName();
            if (dsdName.startsWith("java:app/")) {
                dataSourceDefinitionDescriptor.setResourceId(appName);
            }
            if (dsdName.startsWith("java:global/") || dsdName.startsWith("java:app/")) {
                ResourceInfo resourceInfo = new ResourceInfo(dsdName, appName, null);
                try {
                    resourceNamingService.publishObject(resourceInfo, (Object)proxy, true);
                    dataSourceDefinitionDescriptor.setDeployed(true);
                }
                catch (NamingException e) {
                    _logger.log(Level.WARNING, "dsd.registration.failed", new Object[]{appName, dsdName, e});
                }
            }
        }
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void undeployResource(Object resource) throws Exception {
        DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor = (DataSourceDefinitionDescriptor)resource;
        String poolName = ConnectorsUtil.deriveResourceName((String)dataSourceDefinitionDescriptor.getResourceId(), (String)dataSourceDefinitionDescriptor.getName(), (JavaEEResourceType)JavaEEResourceType.DSDPOOL);
        String resourceName = ConnectorsUtil.deriveResourceName((String)dataSourceDefinitionDescriptor.getResourceId(), (String)dataSourceDefinitionDescriptor.getName(), (JavaEEResourceType)dataSourceDefinitionDescriptor.getResourceType());
        _logger.log(Level.FINE, () -> "DataSourceDefinitionDeployer.undeployResource() : pool-name [" + poolName + "],  resource-name [" + resourceName + "]");
        MyJdbcResource jdbcResource = new MyJdbcResource(poolName, resourceName);
        this.getDeployer(jdbcResource).undeployResource((Object)jdbcResource);
        MyJdbcConnectionPool jdbcCp = new MyJdbcConnectionPool(dataSourceDefinitionDescriptor, poolName);
        this.getDeployer(jdbcCp).undeployResource((Object)jdbcCp);
        dataSourceDefinitionDescriptor.setDeployed(false);
    }

    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for datasource-definition type");
    }

    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for datasource-definition type");
    }

    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for datasource-definition type");
    }

    public boolean handles(Object resource) {
        return resource instanceof DataSourceDefinitionDescriptor;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    class MyJdbcConnectionPool
    extends FakeConfigBean
    implements JdbcConnectionPool {
        private DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor;
        private String name;

        public MyJdbcConnectionPool(DataSourceDefinitionDescriptor desc, String name) {
            this.dataSourceDefinitionDescriptor = desc;
            this.name = name;
        }

        public String getDatasourceClassname() {
            if (!this.getResType().equals("java.sql.Driver")) {
                return this.dataSourceDefinitionDescriptor.getClassName();
            }
            return null;
        }

        public void setDatasourceClassname(String value) throws PropertyVetoException {
        }

        public String getResType() {
            String type = "javax.sql.DataSource";
            try {
                Class<?> dataSoureClass = Thread.currentThread().getContextClassLoader().loadClass(this.dataSourceDefinitionDescriptor.getClassName());
                if (XADataSource.class.isAssignableFrom(dataSoureClass)) {
                    type = "javax.sql.XADataSource";
                } else if (ConnectionPoolDataSource.class.isAssignableFrom(dataSoureClass)) {
                    type = "javax.sql.ConnectionPoolDataSource";
                } else if (DataSource.class.isAssignableFrom(dataSoureClass)) {
                    type = "javax.sql.DataSource";
                } else if (Driver.class.isAssignableFrom(dataSoureClass)) {
                    type = "java.sql.Driver";
                }
            }
            catch (ClassNotFoundException e) {
                _logger.log(Level.FINEST, () -> "Unable to load class [ " + this.dataSourceDefinitionDescriptor.getClassName() + " ] to determine its res-type, defaulting to [javax.sql.DataSource]");
            }
            return type;
        }

        public void setResType(String value) throws PropertyVetoException {
        }

        public String getObjectType() {
            return null;
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.name;
        }

        public String getSteadyPoolSize() {
            int minPoolSize = this.dataSourceDefinitionDescriptor.getMinPoolSize();
            if (minPoolSize == -1) {
                minPoolSize = 8;
            }
            return String.valueOf(minPoolSize);
        }

        public void setSteadyPoolSize(String value) throws PropertyVetoException {
        }

        public String getMaxPoolSize() {
            int maxPoolSize = this.dataSourceDefinitionDescriptor.getMaxPoolSize();
            if (maxPoolSize == -1) {
                maxPoolSize = 32;
            }
            return String.valueOf(maxPoolSize);
        }

        public void setMaxPoolSize(String value) throws PropertyVetoException {
        }

        public String getMaxWaitTimeInMillis() {
            return String.valueOf(60000);
        }

        public void setMaxWaitTimeInMillis(String value) throws PropertyVetoException {
        }

        public String getPoolResizeQuantity() {
            return String.valueOf(2);
        }

        public void setPoolResizeQuantity(String value) throws PropertyVetoException {
        }

        public String getIdleTimeoutInSeconds() {
            long maxIdleTime = this.dataSourceDefinitionDescriptor.getMaxIdleTime();
            if (maxIdleTime == -1L) {
                maxIdleTime = 300L;
            }
            return String.valueOf(maxIdleTime);
        }

        public void setIdleTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getTransactionIsolationLevel() {
            if (this.dataSourceDefinitionDescriptor.getIsolationLevel() == -1) {
                return null;
            }
            return ConnectorsUtil.getTransactionIsolationInt((int)this.dataSourceDefinitionDescriptor.getIsolationLevel());
        }

        public void setTransactionIsolationLevel(String value) throws PropertyVetoException {
        }

        public String getIsIsolationLevelGuaranteed() {
            return String.valueOf("true");
        }

        public void setIsIsolationLevelGuaranteed(String value) throws PropertyVetoException {
        }

        public String getIsConnectionValidationRequired() {
            return String.valueOf("false");
        }

        public void setIsConnectionValidationRequired(String value) throws PropertyVetoException {
        }

        public String getConnectionValidationMethod() {
            return null;
        }

        public void setConnectionValidationMethod(String value) throws PropertyVetoException {
        }

        public String getValidationTableName() {
            return null;
        }

        public void setValidationTableName(String value) throws PropertyVetoException {
        }

        public String getValidationClassname() {
            return null;
        }

        public void setValidationClassname(String value) throws PropertyVetoException {
        }

        public String getFailAllConnections() {
            return String.valueOf("false");
        }

        public void setFailAllConnections(String value) throws PropertyVetoException {
        }

        public String getNonTransactionalConnections() {
            return String.valueOf(!this.dataSourceDefinitionDescriptor.isTransactional());
        }

        public void setNonTransactionalConnections(String value) throws PropertyVetoException {
        }

        public String getAllowNonComponentCallers() {
            return String.valueOf("false");
        }

        public void setAllowNonComponentCallers(String value) throws PropertyVetoException {
        }

        public String getValidateAtmostOncePeriodInSeconds() {
            return String.valueOf(0);
        }

        public void setValidateAtmostOncePeriodInSeconds(String value) throws PropertyVetoException {
        }

        public String getConnectionLeakTimeoutInSeconds() {
            return String.valueOf(0);
        }

        public void setConnectionLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getConnectionLeakReclaim() {
            return String.valueOf(false);
        }

        public void setConnectionLeakReclaim(String value) throws PropertyVetoException {
        }

        public String getConnectionCreationRetryAttempts() {
            return String.valueOf(0);
        }

        public void setConnectionCreationRetryAttempts(String value) throws PropertyVetoException {
        }

        public String getConnectionCreationRetryIntervalInSeconds() {
            return String.valueOf(10);
        }

        public void setConnectionCreationRetryIntervalInSeconds(String value) throws PropertyVetoException {
        }

        public String getStatementTimeoutInSeconds() {
            return String.valueOf(-1);
        }

        public void setStatementTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getLazyConnectionEnlistment() {
            return String.valueOf(false);
        }

        public void setLazyConnectionEnlistment(String value) throws PropertyVetoException {
        }

        public String getLazyConnectionAssociation() {
            return String.valueOf(false);
        }

        public void setLazyConnectionAssociation(String value) throws PropertyVetoException {
        }

        public String getAssociateWithThread() {
            return String.valueOf(false);
        }

        public void setAssociateWithThread(String value) throws PropertyVetoException {
        }

        public String getPooling() {
            return String.valueOf(true);
        }

        public void setPooling(String value) throws PropertyVetoException {
        }

        public String getStatementCacheSize() {
            return String.valueOf(0);
        }

        public void setStatementCacheSize(String value) throws PropertyVetoException {
        }

        public String getMatchConnections() {
            return String.valueOf(true);
        }

        public void setMatchConnections(String value) throws PropertyVetoException {
        }

        public String getMaxConnectionUsageCount() {
            return String.valueOf(0);
        }

        public void setMaxConnectionUsageCount(String value) throws PropertyVetoException {
        }

        public String getWrapJdbcObjects() {
            return String.valueOf(true);
        }

        public void setWrapJdbcObjects(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return this.dataSourceDefinitionDescriptor.getDescription();
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            DataSourceProperty property;
            Properties descriptorProperties = this.dataSourceDefinitionDescriptor.getProperties();
            ArrayList<Property> dataSourceProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : descriptorProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                dataSourceProperties.add(DataSourceDefinitionDeployer.this.convertProperty(key, value));
            }
            if (this.dataSourceDefinitionDescriptor.getUser() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("user", this.dataSourceDefinitionDescriptor.getUser());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getPassword() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("password", this.dataSourceDefinitionDescriptor.getPassword());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getDatabaseName() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("databaseName", this.dataSourceDefinitionDescriptor.getDatabaseName());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getServerName() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("serverName", this.dataSourceDefinitionDescriptor.getServerName());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getPortNumber() != -1) {
                property = DataSourceDefinitionDeployer.this.convertProperty("portNumber", String.valueOf(this.dataSourceDefinitionDescriptor.getPortNumber()));
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getUrl() != null && !this.isStandardPropertiesSet(this.dataSourceDefinitionDescriptor)) {
                property = DataSourceDefinitionDeployer.this.convertProperty("url", this.dataSourceDefinitionDescriptor.getUrl());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getLoginTimeout() != 0L) {
                property = DataSourceDefinitionDeployer.this.convertProperty("loginTimeout", String.valueOf(this.dataSourceDefinitionDescriptor.getLoginTimeout()));
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getMaxStatements() != -1) {
                property = DataSourceDefinitionDeployer.this.convertProperty("maxStatements", String.valueOf(this.dataSourceDefinitionDescriptor.getMaxStatements()));
                dataSourceProperties.add(property);
            }
            return dataSourceProperties;
        }

        private boolean isStandardPropertiesSet(DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor) {
            return dataSourceDefinitionDescriptor.getServerName() != null && dataSourceDefinitionDescriptor.getDatabaseName() != null && dataSourceDefinitionDescriptor.getPortNumber() != -1;
        }

        public Property getProperty(String name) {
            String value = (String)this.dataSourceDefinitionDescriptor.getProperties().get(name);
            return new DataSourceProperty(name, value);
        }

        public String getPropertyValue(String name) {
            return (String)this.dataSourceDefinitionDescriptor.getProperties().get(name);
        }

        public String getPropertyValue(String name, String defaultValue) {
            String value = (String)this.dataSourceDefinitionDescriptor.getProperties().get(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public void injectedInto(Object o) {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
        }

        public String getSqlTraceListeners() {
            return null;
        }

        public void setSqlTraceListeners(String value) throws PropertyVetoException {
        }

        public String getPing() {
            return String.valueOf(false);
        }

        public void setPing(String value) throws PropertyVetoException {
        }

        public String getInitSql() {
            return null;
        }

        public void setInitSql(String value) throws PropertyVetoException {
        }

        public String getDriverClassname() {
            if (this.getResType().equals("java.sql.Driver")) {
                return this.dataSourceDefinitionDescriptor.getClassName();
            }
            return null;
        }

        public void setDriverClassname(String value) throws PropertyVetoException {
        }

        public String getStatementLeakTimeoutInSeconds() {
            return String.valueOf(0);
        }

        public void setStatementLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        public String getStatementLeakReclaim() {
            return String.valueOf(false);
        }

        public void setStatementLeakReclaim(String value) throws PropertyVetoException {
        }

        public String getStatementCacheType() {
            return null;
        }

        public void setStatementCacheType(String value) throws PropertyVetoException {
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }

        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class MyJdbcResource
    extends FakeConfigBean
    implements JdbcResource {
        private String poolName;
        private String jndiName;

        MyJdbcResource(String poolName, String jndiName) {
            this.poolName = poolName;
            this.jndiName = jndiName;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setPoolName(String value) throws PropertyVetoException {
            this.poolName = value;
        }

        public String getObjectType() {
            return null;
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.jndiName;
        }

        public String getEnabled() {
            return String.valueOf(true);
        }

        public void setEnabled(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return null;
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            return null;
        }

        public Property getProperty(String name) {
            return null;
        }

        public String getPropertyValue(String name) {
            return null;
        }

        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        public void injectedInto(Object o) {
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setJndiName(String value) throws PropertyVetoException {
            this.jndiName = value;
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }

        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class DataSourceProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        DataSourceProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        public ConfigBeanProxy getParent() {
            return null;
        }

        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

