/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node.runtime.gf;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import java.util.Map;
import org.glassfish.web.deployment.node.runtime.gf.ConstraintFieldNode;
import org.glassfish.web.deployment.runtime.CacheMapping;
import org.glassfish.web.deployment.runtime.ConstraintField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class CacheMappingNode
extends RuntimeDescriptorNode<CacheMapping> {
    protected CacheMapping descriptor = null;

    public CacheMappingNode() {
        this.registerElementHandler(new XMLElement("constraint-field"), ConstraintFieldNode.class, "addNewConstraintField");
    }

    public CacheMapping getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new CacheMapping();
        }
        return this.descriptor;
    }

    protected Map<String, String> getDispatchTable() {
        Map dispatchTable = super.getDispatchTable();
        dispatchTable.put("servlet-name", "setServletName");
        dispatchTable.put("url-pattern", "setURLPattern");
        dispatchTable.put("cache-helper-ref", "setCacheHelperRef");
        dispatchTable.put("timeout", "setTimeout");
        dispatchTable.put("http-method", "addNewHttpMethod");
        dispatchTable.put("dispatcher", "addNewDispatcher");
        return dispatchTable;
    }

    public void startElement(XMLElement element, Attributes attributes) {
        CacheMapping descriptor = this.getDescriptor();
        if (element.getQName().equals("timeout")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("name".equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue("Timeout", "Name", attributes.getValue(i));
                    continue;
                }
                if (!"scope".equals(attributes.getQName(i))) continue;
                int index = 0;
                while (descriptor.getAttributeValue("Timeout", index, "Name") != null) {
                    ++index;
                }
                descriptor.setAttributeValue("Timeout", index - 1, "Scope", attributes.getValue(i));
            }
        } else if (element.getQName().equals("refresh-field")) {
            descriptor.setRefreshField(true);
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("name".equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue("RefreshField", 0, "Name", attributes.getValue(i));
                    continue;
                }
                if (!"scope".equals(attributes.getQName(i))) continue;
                descriptor.setAttributeValue("RefreshField", 0, "Scope", attributes.getValue(i));
            }
        } else if (element.getQName().equals("key-field")) {
            descriptor.addKeyField(true);
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("name".equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue("KeyField", "Name", attributes.getValue(i));
                    continue;
                }
                if (!"scope".equals(attributes.getQName(i))) continue;
                int index = descriptor.sizeKeyField();
                descriptor.setAttributeValue("KeyField", index - 1, "Scope", attributes.getValue(i));
            }
        } else {
            super.startElement(element, attributes);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, CacheMapping descriptor) {
        String[] httpMethods;
        String scope;
        Node cacheMapping = super.writeDescriptor(parent, nodeName, (Object)descriptor);
        if (descriptor.getServletName() != null) {
            CacheMappingNode.appendTextChild((Node)cacheMapping, (String)"servlet-name", (String)descriptor.getServletName());
        } else {
            CacheMappingNode.appendTextChild((Node)cacheMapping, (String)"url-pattern", (String)descriptor.getURLPattern());
        }
        CacheMappingNode.appendTextChild((Node)cacheMapping, (String)"cache-helper-ref", (String)((String)descriptor.getValue("CacheHelperRef")));
        String[] dispatchers = descriptor.getDispatcher();
        if (dispatchers != null) {
            for (String dispatcher : dispatchers) {
                CacheMappingNode.appendTextChild((Node)cacheMapping, (String)"dispatcher", (String)dispatcher);
            }
        }
        Element timeout = (Element)CacheMappingNode.forceAppendTextChild((Node)cacheMapping, (String)"timeout", (String)((String)descriptor.getValue("Timeout")));
        String name = descriptor.getAttributeValue("Timeout", "Name");
        if (name != null) {
            CacheMappingNode.setAttribute((Element)timeout, (String)"name", (String)name);
        }
        if ((scope = descriptor.getAttributeValue("Timeout", "Scope")) != null) {
            CacheMappingNode.setAttribute((Element)timeout, (String)"scope", (String)scope);
        }
        if (descriptor.isRefreshField()) {
            Element refreshField = CacheMappingNode.appendChild((Node)cacheMapping, (String)"refresh-field");
            CacheMappingNode.setAttribute((Element)refreshField, (String)"name", (String)descriptor.getAttributeValue("RefreshField", "Name"));
            CacheMappingNode.setAttribute((Element)refreshField, (String)"scope", (String)descriptor.getAttributeValue("RefreshField", "Scope"));
        }
        if ((httpMethods = descriptor.getHttpMethod()) != null) {
            for (String httpMethod : httpMethods) {
                CacheMappingNode.appendTextChild((Node)cacheMapping, (String)"http-method", (String)httpMethod);
            }
        }
        if (descriptor.sizeKeyField() > 0) {
            for (int i = 0; i < descriptor.sizeKeyField(); ++i) {
                if (!descriptor.isKeyField(i)) continue;
                Element keyField = CacheMappingNode.appendChild((Node)cacheMapping, (String)"key-field");
                CacheMappingNode.setAttribute((Element)keyField, (String)"name", (String)descriptor.getAttributeValue("KeyField", i, "Name"));
                CacheMappingNode.setAttribute((Element)keyField, (String)"scope", (String)descriptor.getAttributeValue("KeyField", i, "Scope"));
            }
        }
        if (descriptor.sizeConstraintField() > 0) {
            ConstraintField[] constraintFields = descriptor.getConstraintField();
            ConstraintFieldNode cfn = new ConstraintFieldNode();
            cfn.writeDescriptor(cacheMapping, "constraint-field", constraintFields);
        }
        return cacheMapping;
    }
}

