/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.persist.api.MigratableStoreUtil;
import com.sun.messaging.jmq.jmsserver.util.LoopbackAddressException;
import com.sun.messaging.jmq.jmsserver.util.VerifyAddressException;
import com.sun.messaging.jmq.util.UID;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;

public class BrokerAddressImpl
extends BrokerAddress {
    static final long serialVersionUID = 2088198635383118304L;
    private String hostName = null;
    private String instName = null;
    private boolean HAEnabled = false;
    private String brokerID = null;
    private UID brokerSessionUID = null;
    private UID storeSessionUID = null;
    private int port = -1;
    private transient int clusterVersion = 0;
    public static final int VERSION = 100;

    public BrokerAddressImpl(BrokerMQAddress ba, String instName, boolean ha, String brokerID) throws Exception {
        this.hostName = ba.getHost().getHostAddress();
        this.port = ba.getPort();
        this.instName = instName == null ? "???" : instName;
        this.HAEnabled = ha;
        if (ha) {
            this.brokerID = brokerID;
        }
        this.brokerSessionUID = null;
        this.storeSessionUID = null;
        this.initialize(ba);
        this.verifyAddress();
    }

    public BrokerAddressImpl(String hostName, String instName, int port, boolean ha, String brokerID, UID brokerSession, UID storeSession) throws Exception {
        this.initialize(hostName, port);
        this.hostName = this.getMQAddress().getHost().getHostAddress();
        this.instName = instName;
        this.port = port;
        this.HAEnabled = ha;
        this.brokerID = brokerID;
        this.brokerSessionUID = brokerSession;
        this.storeSessionUID = storeSession;
        this.verifyAddress();
    }

    public BrokerAddressImpl() throws Exception {
        this(Globals.getPortMapper().getHostname(), Globals.getConfigName(), Globals.getPortMapper().getPort(), Globals.getHAEnabled(), Globals.getBrokerID(), Globals.getClusterManager().getBrokerSessionUID(), Globals.getClusterManager().getStoreSessionUID());
    }

    @Override
    public int getClusterVersion() {
        return this.clusterVersion;
    }

    public void setClusterVersion(int clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    private void verifyAddress() throws Exception {
        if (this.getMQAddress().getHost().isLoopbackAddress()) {
            throw new LoopbackAddressException(Globals.getBrokerResources().getString("B4214", this.toString()));
        }
        if (Globals.getHAEnabled() != this.getHAEnabled()) {
            throw new VerifyAddressException(Globals.getBrokerResources().getString("B4215", this.toString()));
        }
        if (this.getHAEnabled() && this.brokerID == null) {
            throw new VerifyAddressException(Globals.getBrokerResources().getString("B4216", this.toString()));
        }
    }

    public String getHostName() {
        return this.getMQAddress().getHost().getHostAddress();
    }

    @Override
    public String getInstanceName() {
        return this.instName;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getHost() {
        return this.getMQAddress().getHost();
    }

    @Override
    public boolean getHAEnabled() {
        return this.HAEnabled;
    }

    @Override
    public String getBrokerID() {
        if (Globals.isBDBStore() && !Globals.getSFSHAEnabled()) {
            try {
                return MigratableStoreUtil.makeEffectiveBrokerID(this.instName, this.storeSessionUID);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.brokerID;
    }

    @Override
    public UID getBrokerSessionUID() {
        return this.brokerSessionUID;
    }

    @Override
    public UID getStoreSessionUID() {
        return this.storeSessionUID;
    }

    @Override
    public void setStoreSessionUID(UID uid) {
        this.storeSessionUID = uid;
    }

    @Override
    public final Object clone() {
        BrokerAddressImpl copy;
        try {
            copy = (BrokerAddressImpl)super.getObjectClone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("BrokerAddressImpl: Could not clone: " + e);
            return null;
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BrokerAddressImpl)) {
            return false;
        }
        BrokerAddressImpl addr = (BrokerAddressImpl)obj;
        if (this.getHAEnabled() != addr.getHAEnabled()) {
            return false;
        }
        if (this.getHAEnabled()) {
            if (this.brokerID == null || addr.getBrokerID() == null) {
                return false;
            }
            return this.brokerID.equals(addr.getBrokerID());
        }
        if (!this.instName.equals(addr.instName)) {
            return false;
        }
        if (this.getMQAddress().getHost() == null || addr.getMQAddress().getHost() == null) {
            return false;
        }
        return this.getMQAddress().getHost().equals(addr.getMQAddress().getHost());
    }

    @Override
    public int hashCode() {
        return 31 * this.getMQAddress().getHost().hashCode() + this.instName.hashCode();
    }

    public String toShortString() {
        this.getMQAddress().getHost().getHostName();
        StringBuilder buf = new StringBuilder();
        InetAddress addr = this.getMQAddress().getHost();
        buf.append(addr == null ? "null" : addr.getHostAddress());
        buf.append('?');
        if (this.getHAEnabled()) {
            buf.append("brokerID=");
            buf.append(this.getBrokerID());
            buf.append('&');
            buf.append("ha=true");
        } else {
            buf.append("instName=").append(this.getInstanceName());
            buf.append('&');
            buf.append("ha=false");
        }
        return buf.toString();
    }

    @Override
    public String toProtocolString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getMQAddress().toString());
        buf.append('?');
        buf.append("instName=").append(this.getInstanceName());
        if (this.getBrokerID() != null) {
            buf.append('&');
            buf.append("brokerID=");
            buf.append(this.getBrokerID());
        }
        buf.append('&');
        buf.append("brokerSessionUID=");
        buf.append(this.getBrokerSessionUID());
        buf.append('&');
        buf.append("ha=").append(this.getHAEnabled());
        if (this.getStoreSessionUID() != null) {
            buf.append('&');
            buf.append("storeSessionUID=");
            buf.append(this.getStoreSessionUID());
        }
        return buf.toString();
    }

    @Override
    public BrokerAddress fromProtocolString(String s) throws Exception {
        BrokerMQAddress a = BrokerMQAddress.createAddress(s);
        String ha = a.getProperty("ha");
        boolean isha = Boolean.valueOf(ha);
        return new BrokerAddressImpl(a.getHostName(), a.getProperty("instName"), a.getPort(), isha, a.getProperty("brokerID"), new UID(Long.parseLong(a.getProperty("brokerSessionUID"))), a.getProperty("storeSessionUID") == null ? null : new UID(Long.parseLong(a.getProperty("storeSessionUID"))));
    }

    public void writeBrokerAddress(GPacket gp) {
        gp.putProp((Object)"HA", (Object)this.getHAEnabled());
        if (this.brokerID != null) {
            gp.putProp((Object)"brokerID", (Object)this.getBrokerID());
        }
        if (this.brokerSessionUID != null) {
            gp.putProp((Object)"brokerSession", (Object)this.getBrokerSessionUID().longValue());
        }
        if (this.storeSessionUID != null) {
            gp.putProp((Object)"storeSession", (Object)this.getStoreSessionUID().longValue());
        }
        gp.putProp((Object)"instanceName", (Object)this.getInstanceName());
        gp.putProp((Object)"host", (Object)this.getHostName());
        gp.putProp((Object)"port", (Object)this.getPort());
    }

    public static BrokerAddressImpl readBrokerAddress(GPacket gp) throws Exception {
        if (gp.getProp((Object)"HA") == null) {
            return null;
        }
        boolean ha = (Boolean)gp.getProp((Object)"HA");
        String brokerID = (String)gp.getProp((Object)"brokerID");
        String instName = (String)gp.getProp((Object)"instanceName");
        String host = (String)gp.getProp((Object)"host");
        int port = (Integer)gp.getProp((Object)"port");
        Long brokerSession = (Long)gp.getProp((Object)"brokerSession");
        Long storeSession = (Long)gp.getProp((Object)"storeSession");
        UID buid = null;
        UID suid = null;
        if (brokerSession != null) {
            buid = new UID(brokerSession.longValue());
        }
        if (storeSession != null) {
            suid = new UID(storeSession.longValue());
        }
        BrokerAddressImpl ba = new BrokerAddressImpl(host, instName, port, ha, brokerID, buid, suid);
        return ba;
    }

    @Override
    public void writeBrokerAddress(DataOutputStream dos) throws IOException {
        dos.writeInt(100);
        dos.writeUTF(this.hostName);
        dos.writeUTF(this.instName);
        dos.writeInt(this.port);
        dos.flush();
    }

    @Override
    public void readBrokerAddress(DataInputStream dis) throws IOException {
        int version = dis.readInt();
        if (version > 100) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "BrokerAddress version mismatch."));
        }
        this.hostName = dis.readUTF();
        this.instName = dis.readUTF();
        this.port = dis.readInt();
        this.initialize(this.hostName, this.port);
        this.HAEnabled = false;
        this.brokerID = null;
        this.brokerSessionUID = null;
        this.storeSessionUID = null;
        this.clusterVersion = 0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initialize(this.hostName, this.port);
    }

    public String toString() {
        this.getMQAddress().getHost().getHostName();
        return this.toProtocolString();
    }
}

