/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.admin.ConsumerInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class GetDurablesHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetDurablesHandler.getDEBUG();

    public GetDurablesHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + cmd_props);
        }
        String destination = (String)cmd_props.get("JMQDestination");
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        int status = 200;
        Vector<DurableInfo> v = null;
        String err = null;
        try {
            DestinationUID duid = null;
            if (destination != null) {
                duid = DestinationUID.getUID(destination, false);
            }
            Set s = Subscription.getAllSubscriptions(duid);
            v = new Vector<DurableInfo>();
            for (Subscription sub : s) {
                DurableInfo di = new DurableInfo();
                di.isDurable = sub.isDurable();
                di.isShared = sub.getShared();
                di.isJMSShared = sub.getJMSShared();
                if (di.isDurable) {
                    di.name = sub.getDurableName();
                } else if (di.isJMSShared) {
                    di.name = sub.getNDSubscriptionName();
                }
                di.clientID = sub.getClientID();
                di.isActive = sub.isActive();
                di.uidString = String.valueOf(sub.getConsumerUID().longValue());
                List children = sub.getChildConsumers();
                di.activeCount = children.size();
                di.activeConsumers = new LinkedHashMap();
                for (Consumer c : children) {
                    BrokerAddress addr;
                    ConsumerInfo cinfo = new ConsumerInfo();
                    cinfo.connection = new ConnectionInfo();
                    cinfo.connection.uuid = c.getConsumerUID().getConnectionUID().longValue();
                    cinfo.uidString = String.valueOf(c.getConsumerUID().longValue());
                    ConsumerUID uid = c.getStoredConsumerUID();
                    if (uid != null) {
                        cinfo.subuidString = String.valueOf(uid.longValue());
                    }
                    if ((addr = c.getConsumerUID().getBrokerAddress()) != null) {
                        cinfo.brokerAddressShortString = addr.getMQAddress().getHostAddressNPort() + (String)(addr.getBrokerID() == null ? "" : "[" + addr.getBrokerID() + "]");
                    }
                    di.activeConsumers.put(cinfo.uidString, cinfo);
                }
                di.nMessages = sub.numInProcessMsgs();
                di.consumer = new ConsumerInfo();
                di.consumer.destination = sub.getDestinationUID().getName();
                di.consumer.type = 2;
                di.consumer.selector = sub.getSelectorStr();
                di.consumer.connection = null;
                v.add(di);
            }
        }
        catch (BrokerException ex) {
            err = ex.getMessage();
            status = ex.getStatusCode();
        }
        GetDurablesHandler.setProperties(reply, 23, status, err);
        this.setBodyObject(reply, v);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

