/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TimerTask;

final class GoodbyeTask
extends TimerTask {
    static Logger logger = Globals.getLogger();
    static GoodbyeTask runner = null;
    LinkedList nextSet = new LinkedList();
    LinkedList reasonSet = new LinkedList();
    static long timeout = 0L;
    boolean invalid = false;

    private static synchronized GoodbyeTask get() {
        if (runner == null) {
            runner = new GoodbyeTask();
        }
        return runner;
    }

    public static void initialize(long ttl) {
        timeout = ttl;
    }

    private GoodbyeTask() {
        if (timeout <= 0L) {
            timeout = 300000L;
        }
        try {
            Globals.getTimer(true).schedule((TimerTask)this, timeout, timeout);
        }
        catch (IllegalStateException ex) {
            logger.logStack(4, "Timer canceled ", (Throwable)ex);
            this.invalid = true;
        }
    }

    private synchronized void _addCon(ConnectionUID conuid, String reason) {
        if (this.invalid) {
            return;
        }
        this.reasonSet.add(reason);
        this.nextSet.add(conuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnection(ConnectionUID conuid, String reason) {
        Class<GoodbyeTask> clazz = GoodbyeTask.class;
        synchronized (GoodbyeTask.class) {
            try {
                runner.get()._addCon(conuid, reason);
            }
            catch (IllegalStateException ex) {
                logger.logStack(4, "Timer canceled ", (Throwable)ex);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LinkedList list = null;
        LinkedList reasonlist = null;
        Class<GoodbyeTask> clazz = GoodbyeTask.class;
        synchronized (GoodbyeTask.class) {
            GoodbyeTask goodbyeTask = this;
            synchronized (goodbyeTask) {
                if (this.nextSet.isEmpty()) {
                    runner.cancel();
                    runner = null;
                } else {
                    list = this.nextSet;
                    reasonlist = this.reasonSet;
                    this.nextSet = new LinkedList();
                    this.reasonSet = new LinkedList();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (list == null) {
                return;
            }
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                ConnectionUID uid = (ConnectionUID)((Object)itr.next());
                IMQConnection con = (IMQConnection)Globals.getConnectionManager().getConnection(uid);
                String reason = null;
                try {
                    reason = (String)reasonlist.removeFirst();
                }
                catch (Exception e) {
                    logger.log(4, "Can't get reason string for destroying connection " + uid);
                }
                if (reason == null) {
                    reason = "REASON NOTFOUND";
                }
                if (con != null && con.isValid()) {
                    try {
                        con.destroyConnection(false, 5, reason);
                    }
                    catch (Exception ex) {
                        logger.logStack(4, "error destroying connection " + con, (Throwable)ex);
                    }
                }
                itr.remove();
            }
            return;
        }
    }
}

