/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.AutoClusterBrokerMap;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.RepHAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.MigratableStoreUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import jakarta.inject.Singleton;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.cluster.manager.ha.RepHAClusterManagerImpl")
@Singleton
public class RepHAClusterManagerImpl
extends ClusterManagerImpl {
    private UID localStoreSessionUID = null;

    @Override
    public boolean isHA() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return false;
    }

    @Override
    public void reloadConfig() throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String[] props = new String[]{"imq.cluster.url"};
        this.config.reloadProps(Globals.getConfigName(), props, false);
    }

    @Override
    public String initialize(MQAddress address) throws BrokerException {
        this.logger.log(4, "initializingCluster at " + address);
        if (!Globals.isBDBStore()) {
            throw new BrokerException("Store not bdb type for cluster manage[" + this.getClass().getSimpleName() + "]");
        }
        String url = super.initialize(address);
        if (this.getConfigBrokerCount() > 0 && Globals.getClusterID() == null) {
            throw new BrokerException("imq.cluster.clusterid must set");
        }
        return url;
    }

    @Override
    public ClusteredBroker newClusteredBroker(MQAddress URL2, boolean isLocal, UID sid) throws BrokerException {
        RepHAClusteredBrokerImpl b = new RepHAClusteredBrokerImpl(this, URL2, isLocal, sid);
        if (this.allBrokers instanceof AutoClusterBrokerMap) {
            ((ClusteredBrokerImpl)b).setConfigBroker(true);
        }
        return b;
    }

    @Override
    public String getStoreSessionCreator(UID uid) {
        return null;
    }

    @Override
    protected ClusteredBroker updateBrokerOnActivation(ClusteredBroker broker, Object userData) {
        ((RepHAClusteredBrokerImpl)broker).setStoreSessionUID(((BrokerInfo)userData).getBrokerAddr().getStoreSessionUID());
        return broker;
    }

    @Override
    protected ClusteredBroker updateBrokerOnDeactivation(ClusteredBroker broker, Object userData) {
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusteredBroker getBrokerByNodeName(String nodeName) throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        RepHAClusteredBrokerImpl cb2 = null;
        Map map = this.allBrokers;
        synchronized (map) {
            for (RepHAClusteredBrokerImpl cb2 : this.allBrokers.values()) {
                String instn = cb2.getInstanceName();
                UID ss = cb2.getStoreSessionUID();
                if (instn == null || ss == null || !MigratableStoreUtil.makeEffectiveBrokerID(instn, ss).equals(nodeName)) continue;
                return cb2;
            }
        }
        return null;
    }

    @Override
    public UID getStoreSessionUID() {
        if (this.localStoreSessionUID == null) {
            this.localStoreSessionUID = ((RepHAClusteredBrokerImpl)this.getLocalBroker()).getStoreSessionUID();
        }
        return this.localStoreSessionUID;
    }

    @Override
    protected void addSupportedStoreSessionUID(UID uid) {
        super.addSupportedStoreSessionUID(uid);
    }

    @Override
    protected Map initAllBrokers(MQAddress myaddr) throws BrokerException {
        String cstr = Globals.getConfig().getProperty("imq.cluster.autocluster.brokermapclass");
        if (cstr == null) {
            return super.initAllBrokers(myaddr);
        }
        try {
            Class<?> c = Class.forName(cstr);
            Class[] paramTypes = new Class[]{ClusterManagerImpl.class, MQAddress.class};
            Constructor<?> cons = c.getConstructor(paramTypes);
            Object[] paramArgs = new Object[]{this, myaddr};
            return (Map)cons.newInstance(paramArgs);
        }
        catch (Exception e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LinkedHashSet parseBrokerList() throws MalformedURLException, UnknownHostException {
        if (!(this.allBrokers instanceof AutoClusterBrokerMap)) {
            return super.parseBrokerList();
        }
        String val = this.config.getProperty("imq.cluster.brokerlist");
        if (val != null) {
            this.logger.log(8, "B2219", (Object)("imq.cluster.brokerlist=" + val));
        }
        if ((val = this.config.getProperty("imq.cluster.brokerlist.manual")) != null) {
            this.logger.log(8, "B2219", (Object)("imq.cluster.brokerlist.manual=" + val));
        }
        LinkedHashSet<MQAddress> brokers = new LinkedHashSet<MQAddress>();
        Map map = this.allBrokers;
        synchronized (map) {
            for (Object o : this.allBrokers.values()) {
                RepHAClusteredBrokerImpl b = (RepHAClusteredBrokerImpl)o;
                if (b.isLocalBroker()) continue;
                brokers.add(b.getBrokerURL());
            }
        }
        return brokers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupBrokerID(MQAddress address) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster manager is not initialized");
        }
        if (this.allBrokers instanceof AutoClusterBrokerMap) {
            try {
                Map map = this.allBrokers;
                synchronized (map) {
                    ((AutoClusterBrokerMap)((Object)this.allBrokers)).updateMap();
                }
            }
            catch (BrokerException e) {
                this.logger.logStack(16, e.getMessage(), (Throwable)e);
            }
        }
        return super.lookupBrokerID(address);
    }

    @Override
    public Iterator getConfigBrokers() {
        if (this.allBrokers instanceof AutoClusterBrokerMap) {
            return this.getKnownBrokers(true);
        }
        return super.getConfigBrokers();
    }

    @Override
    public int getConfigBrokerCount() {
        if (this.allBrokers instanceof AutoClusterBrokerMap) {
            return super.getKnownBrokerCount();
        }
        return super.getConfigBrokerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getKnownBrokers(boolean refresh) {
        if (!this.initialized) {
            throw new RuntimeException("Cluster manager is not initialized");
        }
        if (refresh && this.allBrokers instanceof AutoClusterBrokerMap) {
            try {
                Map map = this.allBrokers;
                synchronized (map) {
                    ((AutoClusterBrokerMap)((Object)this.allBrokers)).updateMap(true);
                }
            }
            catch (BrokerException e) {
                this.logger.logStack(16, e.getMessage(), (Throwable)e);
            }
        }
        return super.getKnownBrokers(refresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusteredBroker getBroker(String brokerid) {
        if (this.allBrokers instanceof AutoClusterBrokerMap) {
            ClusteredBroker cb = super.getBroker(brokerid);
            if (cb != null) {
                return cb;
            }
            try {
                Map map = this.allBrokers;
                synchronized (map) {
                    ((AutoClusterBrokerMap)((Object)this.allBrokers)).updateMap(true);
                }
            }
            catch (BrokerException e) {
                this.logger.logStack(16, e.getMessage(), (Throwable)e);
            }
        }
        return super.getBroker(brokerid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String addBroker(MQAddress url, boolean isLocal, boolean isConfig, UID uid) throws NoSuchElementException, BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        if (!(this.allBrokers instanceof AutoClusterBrokerMap)) {
            return super.addBroker(url, isLocal, isConfig, uid);
        }
        String name = null;
        ClusteredBroker cb = null;
        if (isLocal) {
            Map map = this.allBrokers;
            synchronized (map) {
                name = this.lookupBrokerID(url);
                if (name == null) {
                    cb = this.newClusteredBroker(url, isLocal, uid);
                    name = cb.getBrokerName();
                } else {
                    cb = this.getBroker(name);
                }
                Map map2 = this.allBrokers;
                synchronized (map2) {
                    this.allBrokers.put(name, cb);
                }
            }
        }
        name = this.lookupBrokerID(url);
        if (name != null) {
            cb = this.getBroker(name);
        }
        if (name == null || cb == null) {
            throw new NoSuchElementException("Unknown broker " + url);
        }
        if (uid != null) {
            cb.setBrokerSessionUID(uid);
        }
        if (isLocal) {
            cb.setStatus(257, null);
        }
        this.brokerChanged(ClusterReason.ADDED, cb.getBrokerName(), null, cb, uid, null);
        return name;
    }

    @Override
    protected void setupListeners() {
        if (this.allBrokers instanceof AutoClusterBrokerMap) {
            this.config.addListener("imq.cluster.transport", this);
            this.config.addListener("imq.cluster.hostname", this);
            this.config.addListener("imq.cluster.port", this);
            return;
        }
        super.setupListeners();
    }
}

