/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public interface IObject {
    public IdentifiableObject[] getObjects(boolean var1, String var2);

    public long[] getInstanceHashCodes();

    public void addObject(IdentifiableObject var1);

    public static long[] instanceHashCodes(Object object) {
        return IObject.cast(object).map(IObject::getInstanceHashCodes).orElse(new long[0]);
    }

    public static IdentifiableObject[] objects(Object object, boolean create) {
        return IObject.objects(object, create, "");
    }

    public static IdentifiableObject[] objects(Object object, boolean create, String errorMsgPrefix) {
        return IObject.cast(object).map(it -> it.getObjects(create, errorMsgPrefix)).orElse(new IdentifiableObject[0]);
    }

    public static Optional<IObject> cast(Object object) {
        if (object instanceof IObject) {
            return Optional.of((IObject)object);
        }
        return Optional.empty();
    }

    public static class IdentifiableObject {
        private final Object instance;
        private final UUID instanceId;

        public IdentifiableObject(Object instance) {
            this(instance, UUID.randomUUID());
        }

        public IdentifiableObject(Object instance, UUID instanceId) {
            this.instance = instance;
            this.instanceId = instanceId;
        }

        public static Object unwrap(IdentifiableObject object) {
            if (object == null) {
                return null;
            }
            return object.getInstance();
        }

        public UUID getInstanceId() {
            return this.instanceId;
        }

        public Object getInstance() {
            return this.instance;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            IdentifiableObject that = (IdentifiableObject)object;
            return Objects.equals(this.instanceId, that.instanceId);
        }

        public int hashCode() {
            return Objects.hash(this.instanceId);
        }
    }

    public static class IdentifiableArrayObject {
        private final String instanceId = UUID.randomUUID().toString();
        private final Object[] parameters;

        public IdentifiableArrayObject(Object[] parameters) {
            this.parameters = parameters;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            IdentifiableArrayObject that = (IdentifiableArrayObject)object;
            return Arrays.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return Arrays.hashCode(this.parameters);
        }
    }
}

