/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common.ui;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.ui.AutoColumnSizeTableViewer;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PropertiesTableViewer
extends AutoColumnSizeTableViewer {
    private static final String VALUE_COLUMN_PROPERTY = "Value";
    private static final String NAME_COLUMN_PROPERTY = "Property";
    private EObject input;
    private final AdapterFactory adapterFactory;
    private PropertySource propertySource;
    private IPropertyDescriptor[] propertyDescriptors;

    public PropertiesTableViewer(Composite parent, int style, AdapterFactory adapterFactory) {
        super(parent, style | 0x10000 | 0x800);
        this.adapterFactory = adapterFactory;
        this.init();
    }

    private void init() {
        Table propertiesTable = this.getTable();
        TableColumn nameColumn = new TableColumn(propertiesTable, 0);
        nameColumn.setText(NAME_COLUMN_PROPERTY);
        TableColumn valueColumn = new TableColumn(propertiesTable, 0);
        valueColumn.setText(VALUE_COLUMN_PROPERTY);
        propertiesTable.setHeaderVisible(true);
        propertiesTable.setLinesVisible(true);
        this.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                PropertySource propertySource = (PropertySource)inputElement;
                PropertiesTableViewer.this.propertyDescriptors = propertySource.getPropertyDescriptors();
                return PropertiesTableViewer.this.propertyDescriptors;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                IPropertyDescriptor descriptor = (IPropertyDescriptor)element;
                switch (columnIndex) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        ItemPropertyDescriptor.PropertyValueWrapper wrapper;
                        Object value = PropertiesTableViewer.this.propertySource.getPropertyValue(descriptor.getId());
                        if (value instanceof ItemPropertyDescriptor.PropertyValueWrapper && ((value = (wrapper = (ItemPropertyDescriptor.PropertyValueWrapper)value).getEditableValue((Object)PropertiesTableViewer.this.input)) == null || value instanceof List && ((List)value).isEmpty())) {
                            return null;
                        }
                        return descriptor.getLabelProvider().getImage(value);
                    }
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                IPropertyDescriptor descriptor = (IPropertyDescriptor)element;
                switch (columnIndex) {
                    case 0: {
                        return descriptor.getDisplayName();
                    }
                    case 1: {
                        Object value = PropertiesTableViewer.this.propertySource.getPropertyValue(descriptor.getId());
                        return descriptor.getLabelProvider().getText(value);
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IPropertyDescriptor descriptor1 = (IPropertyDescriptor)e1;
                IPropertyDescriptor descriptor2 = (IPropertyDescriptor)e2;
                return descriptor1.getDisplayName().compareTo(descriptor2.getDisplayName());
            }
        });
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (structuredSelection.size() == 1 && firstElement instanceof EStructuralFeature) {
                EStructuralFeature feature = (EStructuralFeature)firstElement;
                IPropertyDescriptor[] iPropertyDescriptorArray = this.propertyDescriptors;
                int n = this.propertyDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertyDescriptor propertyDescriptor = iPropertyDescriptorArray[n2];
                    if (propertyDescriptor.getId().equals(feature.getName())) {
                        super.setSelection((ISelection)new StructuredSelection((Object)propertyDescriptor), true);
                        return;
                    }
                    ++n2;
                }
            }
        }
        super.setSelection(selection, reveal);
    }

    public void setElement(EObject input) {
        this.input = input;
        if (input == null) {
            this.setInput(null);
        } else {
            IItemPropertySource itemPropertySource = (IItemPropertySource)this.adapterFactory.adapt((Notifier)input, IItemPropertySource.class);
            this.propertySource = new PropertySource((Object)input, itemPropertySource);
            this.setInput(this.propertySource);
        }
    }
}

