/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.merge;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="splitStringAttribute", label="Split String Attribute", description="In the metamodel, a new String-typed attribute is created. In the model, the value of another String-typed attribute is split among the two attributes by means of a regular expression.")
public class SplitStringAttribute
extends OperationImplementation {
    @EdaptParameter(main=true, description="The feature whose values are split")
    public EAttribute toSplit;
    @EdaptParameter(description="The class in which the new feature is created")
    public EClass context;
    @EdaptParameter(description="The name of the new attribute")
    public String attributeName;
    @EdaptParameter(description="The regular expression")
    public String pattern;

    @EdaptConstraint(restricts="toSplit", description="The type of the attribute to split has to be String")
    public boolean checkAttributeTypeString(EAttribute toSplit) {
        return toSplit.getEType() == EcorePackage.Literals.ESTRING;
    }

    @EdaptConstraint(restricts="context", description="The class with the new attribute must be a subclass of the class with the attribute to be split")
    public boolean checkContext(EClass context, Metamodel metamodel) {
        EClass eClass = this.toSplit.getEContainingClass();
        return context == eClass || metamodel.getEAllSubTypes(eClass).contains((Object)context);
    }

    public void execute(Metamodel metamodel, Model model) {
        EAttribute newAttribute = MetamodelFactory.newEAttribute((EClass)this.context, (String)this.attributeName, (EDataType)EcorePackage.Literals.ESTRING);
        for (Instance instance : model.getAllInstances(this.context)) {
            String value = (String)instance.get((EStructuralFeature)this.toSplit);
            String[] fragments = value.split(this.pattern);
            if (fragments.length <= 1) continue;
            instance.set((EStructuralFeature)this.toSplit, (Object)fragments[0]);
            instance.set((EStructuralFeature)newAttribute, (Object)fragments[1]);
        }
    }
}

