/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.core.rap;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecp.core.ECPProjectManager;
import org.eclipse.emf.ecp.core.rap.SessionProvider;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.core.ECPProjectManagerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ECPProjectManagerFactory
implements ServiceFactory<ECPProjectManager> {
    private SessionProvider sessionProvider;
    private final Map<String, ECPProjectManagerImpl> sessionRegistry = new HashMap<String, ECPProjectManagerImpl>();

    public ECPProjectManagerFactory() {
        this.init();
    }

    public final void init() {
        this.getSessionProvider();
    }

    private SessionProvider getSessionProvider() {
        if (this.sessionProvider == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(SessionProvider.class);
            this.sessionProvider = (SessionProvider)bundleContext.getService(serviceReference);
        }
        return this.sessionProvider;
    }

    public ECPProjectManager getService(Bundle bundle, ServiceRegistration<ECPProjectManager> registration) {
        ECPProjectManagerImpl ecpProjectManager;
        String sessionId = this.getSessionProvider().getSessionId();
        if (this.sessionRegistry.containsKey(sessionId)) {
            ecpProjectManager = this.sessionRegistry.get(sessionId);
        } else {
            ecpProjectManager = new ECPProjectManagerImpl(sessionId);
            ecpProjectManager.setECPObserverBus(ECPUtil.getECPObserverBus());
            this.sessionRegistry.put(sessionId, ecpProjectManager);
            ecpProjectManager.activate();
        }
        return ecpProjectManager;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ECPProjectManager> registration, ECPProjectManager service) {
    }
}

