/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.swt;

import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.model.common.di.annotations.Renderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.table.model.DetailEditing;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlSWTRenderer;
import org.eclipse.emfforms.bazaar.Bid;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.reveal.DrillUp;
import org.eclipse.emfforms.spi.core.services.reveal.EMFFormsRevealProvider;
import org.eclipse.emfforms.spi.core.services.reveal.Reveal;
import org.eclipse.emfforms.spi.core.services.reveal.RevealHelper;
import org.eclipse.emfforms.spi.core.services.reveal.RevealStep;
import org.osgi.service.component.annotations.Component;

@Component(name="tableDetailRevealProvider")
public class TableDetailRevealProvider
implements EMFFormsRevealProvider {
    private final Double featureBid = 11.0;
    private final Double tableBid = 1.0;

    @Bid
    public Double canReveal(VTableControl tableControl, EObject object, @Optional EStructuralFeature feature, ViewModelContext context) {
        return tableControl.getDetailEditing() == DetailEditing.WITH_PANEL && this.containsRecursively(context, tableControl, object) ? (feature != null ? this.featureBid : this.tableBid) : null;
    }

    private boolean containsRecursively(ViewModelContext context, VTableControl tableControl, EObject object) {
        IObservableList<?> list = this.getTableInput(context, tableControl);
        boolean result = list.stream().filter(EObject.class::isInstance).map(EObject.class::cast).anyMatch(ancestor -> EcoreUtil.isAncestor((EObject)ancestor, (EObject)object));
        return result;
    }

    private IObservableList<?> getTableInput(ViewModelContext context, VTableControl tableControl) {
        IObservableList result = Observables.emptyObservableList();
        try {
            result = ((EMFFormsDatabinding)context.getService(EMFFormsDatabinding.class)).getObservableList(tableControl.getDomainModelReference(), context.getDomainModel());
        }
        catch (DatabindingFailedException databindingFailedException) {
            // empty catch block
        }
        return result;
    }

    @Create
    public RevealStep reveal(ViewModelContext context, RevealHelper helper, VTableControl tableControl, EObject object) {
        RevealStep result = RevealStep.fail();
        if (this.containsRecursively(context, tableControl, object)) {
            result = helper.masterDetail((Object)this, (Object)this);
        }
        return result;
    }

    @DrillUp
    private EObject getParent(ViewModelContext context, VTableControl tableControl, EObject object) {
        EObject result = null;
        IObservableList<?> list = this.getTableInput(context, tableControl);
        result = list.stream().filter(EObject.class::isInstance).map(EObject.class::cast).filter(ancestor -> EcoreUtil.isAncestor((EObject)ancestor, (EObject)object)).findAny().orElse(null);
        return result;
    }

    @Reveal
    private RevealStep revealMaster(@Renderer TableControlSWTRenderer renderer, EObject masterSelection) {
        VTableControl tableControl = (VTableControl)renderer.getVElement();
        return RevealStep.reveal((VElement)tableControl, (EObject)masterSelection, () -> {
            boolean bl = renderer.reveal(masterSelection);
        });
    }
}

