/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.controls.AbstractTextControl;
import org.eclipse.emf.ecp.edit.internal.swt.controls.NumericalHelper;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@Deprecated
public class NumericalControl
extends AbstractTextControl {
    @Override
    protected int getTextWidgetStyle() {
        return super.getTextWidgetStyle() | 0x20000;
    }

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_numerical";
    }

    @Override
    protected String getUnsetLabelText() {
        return LocalizationServiceHelper.getString(this.getClass(), (String)"NumericalControl_NoNumberClickToSetNumber");
    }

    @Override
    protected String getUnsetButtonTooltip() {
        return LocalizationServiceHelper.getString(this.getClass(), (String)"NumericalControl_UnsetNumber");
    }

    @Override
    protected void customizeText(Text text) {
        super.customizeText(text);
        text.setMessage(this.getFormatText());
    }

    @Override
    public Binding bindValue() {
        ISWTObservableValue value = WidgetProperties.text((int)16).observe((Widget)this.getText());
        NumericalTargetToModelUpdateStrategy targetToModelStrategy = new NumericalTargetToModelUpdateStrategy();
        NumericalModelToTargetUpdateStrategy modelToTargetStrategy = new NumericalModelToTargetUpdateStrategy();
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), (UpdateValueStrategy)targetToModelStrategy, (UpdateValueStrategy)modelToTargetStrategy);
        this.createTooltipBinding((UpdateValueStrategy)targetToModelStrategy, (UpdateValueStrategy)modelToTargetStrategy);
        if (this.isEmbedded()) {
            value.addValueChangeListener(new IValueChangeListener((IObservableValue)value, binding, targetToModelStrategy){
                private final /* synthetic */ IObservableValue val$value;
                private final /* synthetic */ Binding val$binding;
                private final /* synthetic */ NumericalTargetToModelUpdateStrategy val$targetToModelStrategy;
                {
                    this.val$value = iObservableValue;
                    this.val$binding = binding;
                    this.val$targetToModelStrategy = numericalTargetToModelUpdateStrategy;
                }

                public void handleValueChange(ValueChangeEvent event) {
                    Object newValue = event.diff.getNewValue();
                    DecimalFormat format = NumericalHelper.setupFormat(NumericalControl.this.getLocale(), NumericalControl.this.getInstanceClass());
                    try {
                        Number number = format.parse((String)newValue);
                        this.val$value.setValue((Object)format.format(number));
                        this.val$binding.updateTargetToModel();
                    }
                    catch (ParseException ex) {
                        this.val$targetToModelStrategy.revertToOldValue(this.val$value);
                    }
                }
            });
        }
        return binding;
    }

    private Class<?> getInstanceClass() {
        return this.getFirstStructuralFeature().getEType().getInstanceClass();
    }

    private String getFormatText() {
        if (NumericalHelper.isInteger(this.getInstanceClass())) {
            return LocalizationServiceHelper.getString(this.getClass(), (String)"NumericalControl_FormatNumerical");
        }
        if (NumericalHelper.isDouble(this.getInstanceClass())) {
            return LocalizationServiceHelper.getString(this.getClass(), (String)"NumericalControl_FormatNumericalDecimal");
        }
        return "";
    }

    private class NumericalModelToTargetUpdateStrategy
    extends AbstractTextControl.ModelToTargetUpdateStrategy {
        private NumericalModelToTargetUpdateStrategy() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return "";
            }
            DecimalFormat format = NumericalHelper.setupFormat(NumericalControl.this.getLocale(), NumericalControl.this.getInstanceClass());
            return format.format(value);
        }
    }

    private class NumericalTargetToModelUpdateStrategy
    extends AbstractTextControl.TargetToModelUpdateStrategy {
        private final DecimalFormat format;

        NumericalTargetToModelUpdateStrategy() {
            this.format = NumericalHelper.setupFormat(NumericalControl.this.getLocale(), NumericalControl.this.getInstanceClass());
        }

        @Override
        protected Object convertValue(Object value) {
            String formatedNumber;
            block12: {
                try {
                    Number number = null;
                    if (value == null) {
                        number = NumericalHelper.getDefaultValue(NumericalControl.this.getInstanceClass());
                    } else {
                        ParsePosition pp = new ParsePosition(0);
                        number = this.format.parse((String)value, pp);
                        if (pp.getErrorIndex() != -1 || pp.getIndex() != ((String)value).length()) {
                            return this.revertToOldValue(value);
                        }
                        if (NumericalHelper.isInteger(NumericalControl.this.getInstanceClass())) {
                            boolean maxValue = false;
                            Class instanceClass = NumericalControl.this.getInstanceClass();
                            String formatedValue = "";
                            if (this.isOfClass(Integer.class, instanceClass) && Integer.MAX_VALUE == number.intValue()) {
                                maxValue = true;
                                formatedValue = this.format.format(Integer.MAX_VALUE);
                            } else if (this.isOfClass(Long.class, instanceClass) && Long.MAX_VALUE == number.longValue()) {
                                maxValue = true;
                                formatedValue = this.format.format(Long.MAX_VALUE);
                            }
                            if (maxValue) {
                                NumericalControl.this.getText().setText(formatedValue);
                                return NumericalHelper.numberToInstanceClass(number, NumericalControl.this.getInstanceClass());
                            }
                        }
                    }
                    formatedNumber = "";
                    if (number != null) {
                        formatedNumber = this.format.format(number);
                    }
                    NumericalControl.this.getText().setText(formatedNumber);
                    if (formatedNumber.length() != 0) break block12;
                    return null;
                }
                catch (ParseException ex) {
                    return this.revertToOldValue(value);
                }
            }
            return NumericalHelper.numberToInstanceClass(this.format.parse(formatedNumber), NumericalControl.this.getInstanceClass());
        }

        private <T extends Number> boolean isOfClass(Class<T> clazz, Class<?> toCheck) {
            try {
                return clazz.isAssignableFrom(toCheck) || clazz.getField("TYPE").get(null).equals(toCheck);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Activator.logException(ex);
                return false;
            }
        }

        private Object revertToOldValue(Object value) {
            if (NumericalControl.this.getFirstStructuralFeature().getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = NumericalControl.this.getModelValue().getValue();
            MessageDialog messageDialog = new MessageDialog(NumericalControl.this.getText().getShell(), LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"NumericalControl_InvalidNumber"), null, LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"NumericalControl_InvalidNumberWillBeUnset"), 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                @Override
                public void handleResult(int codeResult) {
                }
            }.execute();
            if (result == null) {
                NumericalControl.this.getText().setText("");
            } else {
                NumericalControl.this.getDataBindingContext().updateTargets();
            }
            if (NumericalControl.this.getFirstStructuralFeature().isUnsettable() && result == null) {
                NumericalControl.this.showUnsetLabel();
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }
}

