/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.Diagnostician;

public class MetamodelExtent {
    private final Map<EClass, Collection<EObject>> extentMap;
    private Collection<EPackage> rootPackages = new ArrayList<EPackage>();

    public MetamodelExtent() {
        this(Collections.EMPTY_LIST);
    }

    public MetamodelExtent(Collection<EPackage> rootPackages) {
        this.extentMap = new IdentityHashMap<EClass, Collection<EObject>>();
        this.addRootPackages(rootPackages);
    }

    public void addRootPackage(EPackage rootPackage) {
        this.addRootPackages(Arrays.asList(rootPackage));
    }

    public void setRootPackages(Collection<EPackage> rootPackages) {
        this.rootPackages.clear();
        this.addRootPackages(rootPackages);
    }

    public void addRootPackages(Collection<EPackage> rootPackages) {
        for (EPackage rootPackage : rootPackages) {
            if (this.rootPackages.contains(rootPackage)) continue;
            this.rootPackages.add(rootPackage);
        }
        this.clearExtentMap();
    }

    public Collection<EPackage> getRootPackages() {
        return this.rootPackages;
    }

    public Collection<EObject> getChoiceOfValues(EClass type) {
        this.initExtentMap();
        Collection<EObject> collection = this.extentMap.get(type);
        return collection == null ? Collections.emptySet() : collection;
    }

    public void addToExtent(Collection<EObject> elements) {
        for (EObject element : elements) {
            this.addToExtent(element);
        }
    }

    public void addToExtent(EObject element) {
        EClass eClass = element.eClass();
        this.add(element, eClass);
        for (EClass superClass : eClass.getEAllSuperTypes()) {
            this.add(element, superClass);
        }
        if (element instanceof EPackage && element.eContainer() == null && !this.rootPackages.contains(element)) {
            this.addRootPackage((EPackage)element);
        }
    }

    private void add(EObject element, EClass eClass) {
        Collection<EObject> collection = this.extentMap.get(eClass);
        if (collection == null) {
            collection = new HashSet<EObject>();
            this.extentMap.put(eClass, collection);
        }
        collection.add(element);
    }

    public void removeFromExtent(Collection<EObject> elements) {
        for (EObject element : elements) {
            this.removeFromExtent(element);
        }
    }

    public void removeFromExtent(EObject element) {
        EClass eClass = element.eClass();
        this.remove(element, eClass);
        for (EClass superClass : eClass.getEAllSuperTypes()) {
            this.remove(element, superClass);
        }
    }

    private void remove(EObject element, EClass eClass) {
        Collection<EObject> collection = this.extentMap.get(eClass);
        collection.remove(element);
        if (collection.isEmpty()) {
            this.extentMap.remove(collection);
        }
    }

    private void initExtentMap() {
        if (this.extentMap.isEmpty()) {
            for (EClassifier classifier : EcorePackage.eINSTANCE.getEClassifiers()) {
                if (!(classifier instanceof EDataType)) continue;
                this.addToExtent((EObject)classifier);
            }
            for (EPackage rootPackage : this.rootPackages) {
                this.addToExtent((EObject)rootPackage);
                TreeIterator i = rootPackage.eAllContents();
                while (i.hasNext()) {
                    EObject element = (EObject)i.next();
                    this.addToExtent(element);
                }
            }
        }
    }

    public void dispose() {
        this.clearExtentMap();
        this.rootPackages = null;
    }

    public void clearExtentMap() {
        this.extentMap.clear();
    }

    public boolean isConsistent() {
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Diagnostician diagnostician = new Diagnostician();
        for (EPackage p : this.getRootPackages()) {
            diagnostician.validate((EObject)p, (DiagnosticChain)diagnostic);
        }
        return diagnostic.getSeverity() == 0 || diagnostic.getSeverity() == 2;
    }
}

