/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewCache;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewManager;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TableControlDetailPanelRenderer
extends TableControlSWTRenderer {
    private Composite detailPanel;
    private Composite border;
    private ScrolledComposite scrolledComposite;
    private DetailViewManager detailManager;

    @Inject
    public TableControlDetailPanelRenderer(VTableControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabindingEMF emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, imageRegistryService, emfFormsEditSupport);
    }

    @Override
    protected void dispose() {
        if (this.detailManager != null) {
            this.detailManager.dispose();
        }
        super.dispose();
    }

    @Override
    protected Composite createControlComposite(Composite composite) {
        this.border = new Composite(composite, 2048);
        GridLayout gridLayout = GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).create();
        this.border.setLayout((Layout)gridLayout);
        int totalHeight = this.getTableHeightHint() + this.getDetailPanelHeightHint() + gridLayout.verticalSpacing;
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, totalHeight).applyTo((Control)this.border);
        Composite tableComposite = new Composite(this.border, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)tableComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.border);
        this.scrolledComposite = new ScrolledComposite(this.border, 768);
        this.scrolledComposite.setBackground(composite.getBackground());
        this.scrolledComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.scrolledComposite);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.detailPanel = this.createDetailPanel(this.scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.detailPanel);
        this.scrolledComposite.setContent((Control)this.detailPanel);
        this.createDetailManager(this.detailPanel);
        this.detailManager.cacheCurrentDetail();
        this.scrolledComposite.addListener(11, event -> this.scrolledComposite.setMinSize(this.detailPanel.computeSize(-1, -1)));
        return tableComposite;
    }

    void createDetailManager(Composite parent) {
        this.detailManager = new DetailViewManager(parent, __ -> ((VTableControl)this.getVElement()).getDetailView());
        this.detailManager.setCache(DetailViewCache.createCache((ViewModelContext)this.getViewModelContext()));
        this.detailManager.layoutDetailParent(parent);
    }

    protected int getDetailPanelHeightHint() {
        return 400;
    }

    protected Composite createDetailPanel(ScrolledComposite composite) {
        Composite detail = new Composite((Composite)this.scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(detail);
        return detail;
    }

    @Deprecated
    protected VView getView() {
        IEMFValueProperty valueProperty;
        try {
            valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VTableControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return null;
        }
        EReference reference = (EReference)valueProperty.getValueType();
        return this.getView(EcoreUtil.create((EClass)reference.getEReferenceType()));
    }

    protected VView getView(EObject selectedEObject) {
        return this.detailManager.getDetailView(selectedEObject);
    }

    @Override
    protected void applyEnable() {
        super.applyEnable();
        if (this.detailManager != null) {
            this.detailManager.setDetailReadOnly(!((VTableControl)this.getVElement()).isEffectivelyEnabled() || ((VTableControl)this.getVElement()).isEffectivelyReadonly());
        }
    }

    @Override
    protected void applyReadOnly() {
        super.applyReadOnly();
        if (this.detailManager != null) {
            this.detailManager.setDetailReadOnly(!((VTableControl)this.getVElement()).isEffectivelyEnabled() || ((VTableControl)this.getVElement()).isEffectivelyReadonly());
        }
    }

    @Override
    protected void viewerSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            this.handleEmptySelection();
        } else if (((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).size() != 1) {
            this.handleMultiSelection((IStructuredSelection)event.getSelection());
        } else {
            this.handleSingleSelection((IStructuredSelection)event.getSelection());
        }
        super.viewerSelectionChanged(event);
    }

    protected void handleSingleSelection(IStructuredSelection selection) {
        this.disposeDetail();
        EObject object = (EObject)selection.getFirstElement();
        this.renderSelectedObject((Composite)this.detailManager.getDetailContainer(), object);
        this.border.layout(true, true);
        this.scrolledComposite.setMinSize(this.detailPanel.computeSize(-1, -1));
    }

    protected void renderSelectedObject(Composite composite, EObject eObject) {
        if (this.detailManager == null) {
            this.createDetailManager(composite);
        }
        this.detailManager.render(this.getViewModelContext(), this.getVElement(), eObject);
    }

    protected void handleMultiSelection(IStructuredSelection selection) {
        this.disposeDetail();
    }

    protected void handleEmptySelection() {
        this.disposeDetail();
    }

    private void disposeDetail() {
        this.detailManager.cacheCurrentDetail();
    }

    @Override
    @Deprecated
    protected void deleteRows(List<EObject> deletionList, EObject eObject, EStructuralFeature structuralFeature) {
        super.deleteRows(deletionList, eObject, structuralFeature);
        LinkedHashSet toDelete = new LinkedHashSet();
        VDiagnostic diagnostic = ((VTableControl)this.getVElement()).getDiagnostic();
        if (diagnostic == null) {
            return;
        }
        for (EObject deleteObject : deletionList) {
            toDelete.addAll(diagnostic.getDiagnostics(deleteObject));
            TreeIterator eAllContents = deleteObject.eAllContents();
            while (eAllContents.hasNext()) {
                toDelete.addAll(diagnostic.getDiagnostics((EObject)eAllContents.next()));
            }
        }
        diagnostic.getDiagnostics().removeAll(toDelete);
    }
}

