/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.genmodel.util.handler;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emfforms.editor.genmodel.util.GenModelUtil;
import org.eclipse.emfforms.internal.editor.genmodel.util.Activator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddDescriptionTagHandler
extends AbstractHandler {
    private static final String DESCRIPTION_PLACEHOLDER = "<DESCRIPTION-PLACEHOLDER>";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject resourceContents;
        Resource resource;
        ResourceSetImpl resourceSet;
        block12: {
            block11: {
                Object selectedElement;
                block10: {
                    ISelection currentSelection;
                    block9: {
                        currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                        if (IStructuredSelection.class.isInstance(currentSelection)) break block9;
                        Activator.log("Unknown selection");
                        return null;
                    }
                    selectedElement = ((IStructuredSelection)IStructuredSelection.class.cast(currentSelection)).getFirstElement();
                    if (IFile.class.isInstance(selectedElement)) break block10;
                    Activator.log("Selection is not a file");
                    return null;
                }
                IFile file = (IFile)IFile.class.cast(selectedElement);
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
                resourceSet = new ResourceSetImpl();
                resource = resourceSet.createResource(uri);
                resource.load(null);
                if (resource.getContents().size() == 1) break block11;
                Activator.log("Multiple contents detected");
                return null;
            }
            resourceContents = (EObject)resource.getContents().get(0);
            if (GenModel.class.isInstance(resourceContents)) break block12;
            Activator.log("Selection is not a genmodel");
            return null;
        }
        try {
            GenModel genModel = (GenModel)GenModel.class.cast(resourceContents);
            GenModelUtil.addDescriptionTags(genModel, DESCRIPTION_PLACEHOLDER);
            for (Resource r : resourceSet.getResources()) {
                try {
                    r.save(null);
                }
                catch (IOException ex) {
                    Activator.log(MessageFormat.format("Could not save resource with URI {0}.", resource.getURI()), ex);
                }
            }
        }
        catch (IOException ex) {
            Activator.log("Could not load GenModel", ex);
        }
        return null;
    }
}

