/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model.util;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;

public final class SegmentResolvementUtil {
    private SegmentResolvementUtil() {
    }

    public static void resolveSegments(List<VDomainModelReferenceSegment> segments, EClass rootEClass, Consumer<EStructuralFeature> callback) {
        EClass currentRoot = rootEClass;
        int i = 0;
        while (i < segments.size() - 1) {
            VDomainModelReferenceSegment segment = segments.get(i);
            if (!VFeatureDomainModelReferenceSegment.class.isInstance(segment)) {
                return;
            }
            VFeatureDomainModelReferenceSegment featureSegment = (VFeatureDomainModelReferenceSegment)segment;
            EStructuralFeature feature = currentRoot.getEStructuralFeature(featureSegment.getDomainModelFeature());
            if (feature == null || !EReference.class.isInstance(feature)) {
                return;
            }
            EReference reference = (EReference)feature;
            currentRoot = reference.getEReferenceType();
            callback.accept((EStructuralFeature)reference);
            ++i;
        }
        VDomainModelReferenceSegment segment = segments.get(segments.size() - 1);
        if (!VFeatureDomainModelReferenceSegment.class.isInstance(segment)) {
            return;
        }
        VFeatureDomainModelReferenceSegment featureSegment = (VFeatureDomainModelReferenceSegment)segment;
        EStructuralFeature feature = currentRoot.getEStructuralFeature(featureSegment.getDomainModelFeature());
        if (feature == null) {
            return;
        }
        callback.accept(feature);
    }

    public static List<EStructuralFeature> resolveSegmentsToFeatureList(List<VDomainModelReferenceSegment> segments, EClass rootEClass) {
        LinkedList<EStructuralFeature> result = new LinkedList<EStructuralFeature>();
        SegmentResolvementUtil.resolveSegments(segments, rootEClass, result::add);
        return result;
    }
}

