/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.internal.e3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecp.edit.spi.ECPContextDisposedListener;
import org.eclipse.emf.ecp.edit.spi.util.ECPModelElementChangeListener;
import org.eclipse.emf.ecp.editor.e3.AbstractMEEditorPage;
import org.eclipse.emf.ecp.editor.e3.ECPEditorContext;
import org.eclipse.emf.ecp.editor.e3.MEEditorInput;
import org.eclipse.emf.ecp.editor.e3.StatusMessageProvider;
import org.eclipse.emf.ecp.editor.internal.e3.Activator;
import org.eclipse.emf.ecp.editor.internal.e3.MEEditorPage;
import org.eclipse.emf.ecp.editor.internal.e3.Messages;
import org.eclipse.emf.ecp.editor.internal.e3.PageCandidate;
import org.eclipse.emf.ecp.editor.internal.e3.ShortLabelProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;

public class MEEditor
extends SharedHeaderFormEditor {
    private static final String STATUS_EXTENSIONPOINT_ID = "org.eclipse.emf.ecp.editor.statusmessage";
    private static final String DEFAULT_PAGE_ID = "Edit";
    private static final String REPLACE_ATTRIBUTE = "replace";
    private static final String EDITOR_PAGES_EXTENSIONPOINT_ID = "org.eclipse.emf.ecp.editor.pages";
    public static final String ID = "org.eclipse.emf.ecp.editor.internal.e3";
    private MEEditorPage mePage;
    private StatusMessageProvider statusMessageProvider;
    private ECPModelElementChangeListener modelElementChangeListener;
    private ECPEditorContext modelElementContext;
    private ECPContextDisposedListener modelElementContextListener;
    private MEEditorInput meInput;
    private ShortLabelProvider shortLabelProvider;
    private ComposedAdapterFactory composedAdapterFactory;

    protected void addPages() {
        String editorID = DEFAULT_PAGE_ID;
        String editorDesc = Messages.MEEditor_Standard_View_Name;
        MEEditorInput editorInput = (MEEditorInput)this.getEditorInput();
        IConfigurationElement[] configTemp = Platform.getExtensionRegistry().getConfigurationElementsFor(EDITOR_PAGES_EXTENSIONPOINT_ID);
        IConfigurationElement[] configIn = null;
        boolean replaceMEEditor = false;
        int counter = 0;
        int i = 0;
        while (i < configTemp.length) {
            if (configTemp[i].getAttribute(REPLACE_ATTRIBUTE) != null && configTemp[i].getAttribute(REPLACE_ATTRIBUTE).equals(DEFAULT_PAGE_ID)) {
                replaceMEEditor = true;
                try {
                    AbstractMEEditorPage newPage = (AbstractMEEditorPage)configTemp[i].createExecutableExtension("class");
                    FormPage createPage = newPage.createPage((FormEditor)this, this.modelElementContext);
                    if (createPage != null) {
                        this.addPage((IFormPage)createPage);
                    }
                }
                catch (CoreException e1) {
                    Activator.logException((Exception)((Object)e1));
                }
                configIn = new IConfigurationElement[configTemp.length - 1];
                int j = 0;
                int k = 0;
                while (j < configTemp.length - 1) {
                    if (counter == j) {
                        --j;
                    } else {
                        configIn[j] = configTemp[k];
                    }
                    ++j;
                    ++k;
                }
                break;
            }
            ++counter;
            ++i;
        }
        if (!replaceMEEditor) {
            try {
                this.mePage = editorInput.getProblemFeature() != null ? new MEEditorPage(this, DEFAULT_PAGE_ID, editorDesc, this.modelElementContext, this.modelElementContext.getDomainObject(), editorInput.getProblemFeature()) : new MEEditorPage(this, DEFAULT_PAGE_ID, editorDesc, this.modelElementContext, this.modelElementContext.getDomainObject());
                this.addPage((IFormPage)this.mePage);
                configIn = configTemp;
            }
            catch (PartInitException e) {
                Activator.logException((Exception)((Object)e));
            }
        }
        List<IConfigurationElement> config = PageCandidate.getPages(configIn);
        for (IConfigurationElement e : config) {
            try {
                AbstractMEEditorPage newPage = (AbstractMEEditorPage)e.createExecutableExtension("class");
                FormPage createPage = newPage.createPage((FormEditor)this, this.modelElementContext);
                if (createPage == null) continue;
                this.addPage((IFormPage)createPage);
            }
            catch (CoreException e1) {
                Activator.logException((Exception)((Object)e1));
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!(input instanceof MEEditorInput)) {
            throw new PartInitException("MEEditor is only appliable for MEEditorInputs");
        }
        this.setInput(input);
        this.meInput = (MEEditorInput)input;
        this.modelElementContext = this.meInput.getModelElementContext();
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.shortLabelProvider = new ShortLabelProvider((AdapterFactory)this.composedAdapterFactory);
        this.setPartName(this.shortLabelProvider.getText(this.modelElementContext.getDomainObject()));
        this.setTitleImage(this.shortLabelProvider.getImage(this.modelElementContext.getDomainObject()));
        this.modelElementContextListener = new ECPContextDisposedListener(){

            public void contextDisposed() {
                MEEditor.this.close(false);
            }
        };
        this.modelElementContext.addECPContextDisposeListener(this.modelElementContextListener);
        this.modelElementChangeListener = new ECPModelElementChangeListener(this.modelElementContext.getDomainObject()){

            public void onChange(Notification notification) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MEEditor.this.updateIcon();
                        MEEditor.this.setPartName(MEEditor.this.shortLabelProvider.getText(MEEditor.this.modelElementContext.getDomainObject()));
                        if (MEEditor.this.mePage != null) {
                            MEEditor.this.mePage.updateSectionTitle();
                        }
                        MEEditor.this.updateStatusMessage();
                    }
                });
            }
        };
        this.initStatusProvider();
        this.updateStatusMessage();
    }

    private void initStatusProvider() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(STATUS_EXTENSIONPOINT_ID);
        ArrayList<IConfigurationElement> provider = new ArrayList<IConfigurationElement>();
        provider.addAll(Arrays.asList(configurationElements));
        int priority = 0;
        for (IConfigurationElement e : provider) {
            try {
                StatusMessageProvider statusMessageProvider = (StatusMessageProvider)e.createExecutableExtension("class");
                int newpriority = statusMessageProvider.canRender(this.modelElementContext.getDomainObject());
                if (newpriority <= priority) continue;
                priority = newpriority;
                this.statusMessageProvider = statusMessageProvider;
            }
            catch (CoreException e1) {
                Activator.logException((Exception)((Object)e1));
            }
        }
    }

    private void updateStatusMessage() {
        if (this.statusMessageProvider != null) {
            this.getEditorSite().getActionBars().getStatusLineManager().setMessage(this.statusMessageProvider.getMessage(this.modelElementContext.getDomainObject()));
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
        super.setFocus();
        if (this.mePage != null) {
            this.mePage.setFocus();
        }
        this.updateStatusMessage();
    }

    public void dispose() {
        this.modelElementChangeListener.remove();
        this.modelElementContext.dispose();
        this.meInput.dispose();
        this.composedAdapterFactory.dispose();
        this.shortLabelProvider.dispose();
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    private void updateIcon() {
        this.setTitleImage(this.shortLabelProvider.getImage(this.modelElementContext.getDomainObject()));
        if (this.mePage != null) {
            try {
                this.mePage.getManagedForm().getForm().setImage(this.shortLabelProvider.getImage(this.modelElementContext.getDomainObject()));
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }
}

