/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.core.rap;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecp.core.ECPRepositoryManager;
import org.eclipse.emf.ecp.core.rap.SessionProvider;
import org.eclipse.emf.ecp.internal.core.ECPRepositoryManagerImpl;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ECPRepositoryManagerFactory
implements ServiceFactory<ECPRepositoryManager>,
UISessionListener {
    private SessionProvider sessionProvider;
    private final Map<String, ECPRepositoryManager> sessionRegistry = new HashMap<String, ECPRepositoryManager>();

    public ECPRepositoryManagerFactory() {
        this.init();
    }

    public void init() {
        this.getSessionProvider();
    }

    private SessionProvider getSessionProvider() {
        if (this.sessionProvider == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(SessionProvider.class);
            this.sessionProvider = (SessionProvider)bundleContext.getService(serviceReference);
        }
        return this.sessionProvider;
    }

    public final ECPRepositoryManager getService(Bundle bundle, ServiceRegistration<ECPRepositoryManager> registration) {
        ECPRepositoryManagerImpl ecpRepositoryManager;
        String sessionId = this.getSessionProvider().getSessionId();
        this.getSessionProvider().registerListenerWithSession(this);
        if (this.sessionRegistry.containsKey(sessionId)) {
            ecpRepositoryManager = this.sessionRegistry.get(sessionId);
        } else {
            ecpRepositoryManager = new ECPRepositoryManagerImpl();
            this.sessionRegistry.put(sessionId, (ECPRepositoryManager)ecpRepositoryManager);
            ((Lifecycle)ecpRepositoryManager).activate();
        }
        return ecpRepositoryManager;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ECPRepositoryManager> registration, ECPRepositoryManager service) {
    }

    public void beforeDestroy(UISessionEvent event) {
        this.sessionRegistry.remove(event.getUISession().toString());
    }
}

