/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt;

import org.eclipse.emf.ecp.view.internal.core.swt.ComboUtil;
import org.eclipse.emf.ecp.view.internal.core.swt.TimeBoundStringBuffer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class MatchFreeItemComboViewer
extends ComboViewer {
    private final TimeBoundStringBuffer searchBuffer = new TimeBoundStringBuffer();
    private String initialText;

    public MatchFreeItemComboViewer(CCombo combo) {
        super(combo);
        this.setupListeners();
    }

    public void onEnter() {
        this.searchBuffer.reset();
        ComboUtil.setClosestMatch(this.getCCombo(), this.getCCombo().getText());
    }

    protected void onEscape() {
        this.searchBuffer.reset();
    }

    protected void setupListeners() {
        this.getCCombo().addKeyListener((KeyListener)new MatchItemKeyAdapter());
        this.getCCombo().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                MatchFreeItemComboViewer.this.initialText = MatchFreeItemComboViewer.this.getCCombo().getText();
                CCombo control = MatchFreeItemComboViewer.this.getCCombo();
                if (control != null) {
                    int itemCount = control.getItemCount();
                    if (itemCount == 0) {
                        control.setVisibleItemCount(0);
                    } else {
                        control.setVisibleItemCount(itemCount <= 25 ? itemCount : 25);
                    }
                }
            }
        });
    }

    class MatchItemKeyAdapter
    extends KeyAdapter {
        MatchItemKeyAdapter() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.keyCode == 27) {
                MatchFreeItemComboViewer.this.onEscape();
            } else if (keyEvent.keyCode == 13) {
                MatchFreeItemComboViewer.this.onEnter();
            } else if (!Character.isISOControl(keyEvent.character)) {
                if (MatchFreeItemComboViewer.this.getCCombo().getListVisible()) {
                    ComboUtil.setClosestMatch(MatchFreeItemComboViewer.this.getCCombo(), MatchFreeItemComboViewer.this.searchBuffer.asString());
                } else {
                    ComboUtil.setClosestMatch(MatchFreeItemComboViewer.this.getCCombo(), MatchFreeItemComboViewer.this.getCCombo().getText());
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (MatchFreeItemComboViewer.this.searchBuffer.timedOut() || !MatchFreeItemComboViewer.this.getCCombo().getListVisible()) {
                MatchFreeItemComboViewer.this.searchBuffer.reset();
            }
            if (keyEvent.keyCode == 27) {
                MatchFreeItemComboViewer.this.getCCombo().setText(MatchFreeItemComboViewer.this.initialText);
            }
            if (!Character.isISOControl(keyEvent.character) && MatchFreeItemComboViewer.this.getCCombo().getListVisible()) {
                keyEvent.doit = false;
                MatchFreeItemComboViewer.this.searchBuffer.addLast(Character.valueOf(keyEvent.character));
            }
        }
    }
}

