/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.expressions.definitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.expressions.Expression;
import org.eclipse.ease.ui.scripts.expressions.ICompositeExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.IExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.definitions.AbstractExpressionDefinition;

public abstract class AbstractCompositeExpressionDefinition
extends AbstractExpressionDefinition
implements ICompositeExpressionDefinition {
    private List<IExpressionDefinition> fChildren = null;

    protected int getChildLimit() {
        try {
            return Integer.parseInt(this.getConfigurationElement().getAttribute("childElements"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public boolean acceptsChild() {
        return this.getChildLimit() < 0 || this.getChildLimit() > 0 && (this.fChildren == null || this.getChildLimit() > this.fChildren.size());
    }

    @Override
    public boolean addChild(IExpressionDefinition expression) {
        if (this.acceptsChild()) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList<IExpressionDefinition>(2);
            }
            this.fChildren.add(expression);
            expression.setParent(this);
            return true;
        }
        return false;
    }

    @Override
    public List<IExpressionDefinition> getChildren() {
        return this.fChildren != null ? this.fChildren : Collections.emptyList();
    }

    protected List<Expression> getChildrenAsExpressions() {
        return this.getChildren().stream().map(e -> e.toCoreExpression()).collect(Collectors.toList());
    }

    @Override
    public void removeChild(IExpressionDefinition element) {
        this.getChildren().remove(element);
    }

    @Override
    public String serialize() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toString());
        builder.append('(');
        String serializedParameters = this.serializeParameters();
        String serializedChildren = this.serializeChildren();
        builder.append(serializedParameters);
        if (!serializedParameters.isEmpty() && !serializedChildren.isEmpty()) {
            builder.append(", ");
        }
        builder.append(serializedChildren);
        builder.append(')');
        return builder.toString();
    }

    private String serializeChildren() {
        StringBuilder builder = new StringBuilder();
        for (IExpressionDefinition child : this.getChildren()) {
            builder.append(child.serialize());
            builder.append(", ");
        }
        if (!this.getChildren().isEmpty()) {
            builder.delete(builder.length() - 2, builder.length());
        }
        return builder.toString();
    }
}

