/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.IScriptEngine;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class EaseClassLoader
extends ClassLoader {
    private final Map<IScriptEngine, URLClassLoader> fRegisteredJars = new HashMap<IScriptEngine, URLClassLoader>();
    private final Collection<URLClassLoader> fTraversingURLClassLoader = new HashSet<URLClassLoader>();

    public EaseClassLoader() {
        super(((BundleWiring)FrameworkUtil.getBundle(EaseClassLoader.class).adapt(BundleWiring.class)).getClassLoader());
    }

    public EaseClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Job currentJob = Job.getJobManager().currentJob();
        URLClassLoader classLoader = this.fRegisteredJars.get(currentJob);
        if (classLoader != null && !this.fTraversingURLClassLoader.contains(classLoader)) {
            this.fTraversingURLClassLoader.add(classLoader);
            try {
                Class<?> clazz = classLoader.loadClass(name);
                if (clazz != null) {
                    Class<?> clazz2 = clazz;
                    return clazz2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            finally {
                this.fTraversingURLClassLoader.remove(classLoader);
            }
        }
        return super.findClass(name);
    }

    public void registerURL(IScriptEngine engine, URL url) {
        if (!this.fRegisteredJars.containsKey(engine)) {
            this.fRegisteredJars.put(engine, URLClassLoader.newInstance(new URL[]{url}, this));
        } else {
            URL[] registeredURLs = this.fRegisteredJars.get(engine).getURLs();
            List<URL> urlList = Arrays.asList(registeredURLs);
            if (!urlList.contains(url)) {
                URL[] updatedURLs = Arrays.copyOf(registeredURLs, registeredURLs.length + 1);
                updatedURLs[updatedURLs.length - 1] = url;
                this.fRegisteredJars.put(engine, URLClassLoader.newInstance(updatedURLs, this));
            }
        }
    }

    public void unregisterEngine(IScriptEngine engine) {
        this.fRegisteredJars.remove(engine);
    }
}

