/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.ease.debugging.ScriptDebugTarget;
import org.eclipse.ease.debugging.ScriptDebugThread;

public abstract class ScriptDebugElement
extends DebugElement
implements ITerminate,
ISuspendResume,
IDisconnect,
IStep {
    public ScriptDebugElement(ScriptDebugTarget target) {
        super((IDebugTarget)target);
    }

    public ScriptDebugTarget getDebugTarget() {
        return (ScriptDebugTarget)super.getDebugTarget();
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return false;
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        throw new DebugException((IStatus)new Status(4, "Activator.PLUGIN_ID", "getMemoryBlock() not supported by " + this.getDebugTarget().getName()));
    }

    public boolean canDisconnect() {
        return !this.isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.getDebugTarget().disconnect();
    }

    public boolean isDisconnected() {
        return this.isTerminated();
    }

    public boolean canStepInto() {
        ScriptDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].canStepInto();
        }
        return false;
    }

    public boolean canStepOver() {
        ScriptDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].canStepOver();
        }
        return false;
    }

    public boolean canStepReturn() {
        ScriptDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].canStepReturn();
        }
        return false;
    }

    public void stepInto() throws DebugException {
        ScriptDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            threads[0].stepInto();
        }
    }

    public void stepOver() throws DebugException {
        ScriptDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            threads[0].stepOver();
        }
    }

    public void stepReturn() throws DebugException {
        ScriptDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            threads[0].stepReturn();
        }
    }

    protected static enum State {
        NOT_STARTED,
        SUSPENDED,
        RESUMED,
        STEPPING,
        TERMINATED;

    }
}

